/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.ListUtil;
import com.intellij.ui.RowsDnDSupport;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.util.ui.EditableModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ListToolbarDecorator<T>
extends ToolbarDecorator {
    private final JList<T> myList;
    private final EditableModel myEditableModel;

    ListToolbarDecorator(@NotNull JList<T> list, @Nullable EditableModel editableModel) {
        if (list == null) {
            ListToolbarDecorator.$$$reportNull$$$0(0);
        }
        this.myList = list;
        this.myEditableModel = editableModel;
        this.myDownActionEnabled = true;
        this.myUpActionEnabled = true;
        this.myRemoveActionEnabled = true;
        this.myAddActionEnabled = true;
        this.createActions();
        this.myList.addListSelectionListener(__ -> this.updateButtons());
        ListDataListener modelListener = new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                ListToolbarDecorator.this.updateButtons();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                ListToolbarDecorator.this.updateButtons();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                ListToolbarDecorator.this.updateButtons();
            }
        };
        this.myList.getModel().addListDataListener(modelListener);
        this.myList.addPropertyChangeListener("model", evt -> {
            if (evt.getOldValue() != null) {
                ((ListModel)evt.getOldValue()).removeListDataListener(modelListener);
            }
            if (evt.getNewValue() != null) {
                ((ListModel)evt.getNewValue()).addListDataListener(modelListener);
            }
        });
        this.myList.addPropertyChangeListener("enabled", __ -> this.updateButtons());
    }

    private void createActions() {
        this.myRemoveAction = __ -> {
            ListUtil.removeSelectedItems(this.myList);
            this.updateButtons();
        };
        this.myUpAction = __ -> {
            ListUtil.moveSelectedItemsUp(this.myList);
            this.updateButtons();
        };
        this.myDownAction = __ -> {
            ListUtil.moveSelectedItemsDown(this.myList);
            this.updateButtons();
        };
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        JList<T> jList = this.myList;
        if (jList == null) {
            ListToolbarDecorator.$$$reportNull$$$0(1);
        }
        return jList;
    }

    @Override
    protected void updateButtons() {
        CommonActionsPanel p = this.getActionsPanel();
        if (p != null) {
            boolean someElementSelected;
            if (this.myList.isEnabled()) {
                int index = this.myList.getSelectedIndex();
                boolean bl = someElementSelected = 0 <= index && index < this.myList.getModel().getSize();
                if (someElementSelected) {
                    boolean downEnable = this.myList.getMaxSelectionIndex() < this.myList.getModel().getSize() - 1;
                    boolean upEnable = this.myList.getMinSelectionIndex() > 0;
                    boolean editEnabled = this.myList.getSelectedIndices().length == 1;
                    p.setEnabled(CommonActionsPanel.Buttons.EDIT, editEnabled);
                    p.setEnabled(CommonActionsPanel.Buttons.UP, upEnable);
                    p.setEnabled(CommonActionsPanel.Buttons.DOWN, downEnable);
                } else {
                    p.setEnabled(CommonActionsPanel.Buttons.EDIT, false);
                    p.setEnabled(CommonActionsPanel.Buttons.UP, false);
                    p.setEnabled(CommonActionsPanel.Buttons.DOWN, false);
                }
                p.setEnabled(CommonActionsPanel.Buttons.ADD, true);
            } else {
                someElementSelected = false;
                p.setEnabled(CommonActionsPanel.Buttons.ADD, false);
                p.setEnabled(CommonActionsPanel.Buttons.UP, false);
                p.setEnabled(CommonActionsPanel.Buttons.DOWN, false);
            }
            p.setEnabled(CommonActionsPanel.Buttons.REMOVE, someElementSelected);
            this.updateExtraElementActions(someElementSelected);
        }
    }

    @Override
    @NotNull
    public ToolbarDecorator setVisibleRowCount(int rowCount) {
        this.myList.setVisibleRowCount(rowCount);
        ListToolbarDecorator listToolbarDecorator = this;
        if (listToolbarDecorator == null) {
            ListToolbarDecorator.$$$reportNull$$$0(2);
        }
        return listToolbarDecorator;
    }

    @Override
    protected boolean isModelEditable() {
        return this.myEditableModel != null || this.myList.getModel() instanceof EditableModel;
    }

    @Override
    protected void installDnDSupport() {
        RowsDnDSupport.install(this.myList, this.myEditableModel != null ? this.myEditableModel : (EditableModel)this.myList.getModel());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/ListToolbarDecorator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/ListToolbarDecorator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "setVisibleRowCount";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

