/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.copyright.psi;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.maddyhome.idea.copyright.CopyrightProfile;
import com.maddyhome.idea.copyright.CopyrightUpdaters;
import com.maddyhome.idea.copyright.psi.UpdateCopyright;
import com.maddyhome.idea.copyright.psi.UpdateCopyrightsProvider;
import org.jetbrains.annotations.Nullable;

public class UpdateCopyrightFactory {
    private static final Logger logger = Logger.getInstance((String)UpdateCopyrightFactory.class.getName());

    @Nullable
    public static UpdateCopyright createUpdateCopyright(Project project, Module module, PsiFile file, CopyrightProfile options) {
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        return UpdateCopyrightFactory.createUpdateCopyright(project, module, virtualFile, virtualFile.getFileType(), options);
    }

    private static UpdateCopyright createUpdateCopyright(Project project, Module module, VirtualFile file, FileType type, CopyrightProfile options) {
        logger.debug("file=" + file);
        logger.debug("type=" + type.getName());
        return ((UpdateCopyrightsProvider)CopyrightUpdaters.INSTANCE.forFileType(type)).createInstance(project, module, file, type, options);
    }

    private UpdateCopyrightFactory() {
    }
}

