/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.newEditor;

import com.intellij.ide.ui.search.ComponentHighlightingListener;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ex.GlassPanel;
import com.intellij.openapi.options.newEditor.SettingsFilter;
import com.intellij.openapi.ui.AbstractPainter;
import com.intellij.openapi.ui.Painter;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Component;
import java.awt.Graphics2D;
import java.util.HashMap;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

abstract class SpotlightPainter
extends AbstractPainter
implements ComponentHighlightingListener {
    private final HashMap<String, String> myConfigurableOption;
    private final MergingUpdateQueue myQueue;
    private final GlassPanel myGlassPanel;
    private final JComponent myTarget;
    boolean myVisible;

    SpotlightPainter(JComponent target2, @NotNull Disposable parent) {
        if (parent == null) {
            SpotlightPainter.$$$reportNull$$$0(0);
        }
        this.myConfigurableOption = new HashMap();
        this.myQueue = new MergingUpdateQueue("SettingsSpotlight", 200, false, target2, parent, target2);
        this.myGlassPanel = new GlassPanel(target2);
        this.myTarget = target2;
        IdeGlassPaneUtil.installPainter((JComponent)target2, (Painter)this, (Disposable)parent);
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect(parent);
        connection.subscribe(ComponentHighlightingListener.TOPIC, (Object)this);
    }

    public void executePaint(Component component2, Graphics2D g) {
        if (this.myVisible && this.myGlassPanel.isVisible()) {
            this.myGlassPanel.paintSpotlight(g, this.myTarget);
        }
    }

    public boolean needsRepaint() {
        return true;
    }

    void updateLater() {
        this.myQueue.queue(new Update(this){

            public void run() {
                SpotlightPainter.this.updateNow();
            }
        });
    }

    abstract void updateNow();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void update(SettingsFilter filter, Configurable configurable, JComponent component) {
        if (configurable == null) {
            this.myGlassPanel.clear();
            this.myVisible = false;
        } else if (component != null) {
            this.myGlassPanel.clear();
            text = filter.getFilterText();
            this.myVisible = text.isEmpty() == false;
            searchable = new SearchableConfigurable.Delegate(configurable);
            try {
                SearchUtil.lightOptions((SearchableConfigurable)searchable, component, text);
                search = searchable.enableSearch(text);
                if (search == null || filter.contains(configurable) || text.equals(this.myConfigurableOption.get(searchable.getId()))) ** GOTO lbl23
                search.run();
            }
            finally {
                this.myConfigurableOption.put(searchable.getId(), text);
            }
        } else if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.updateLater();
            return;
        }
lbl23:
        // 5 sources

        this.fireNeedsRepaint(this.myGlassPanel);
    }

    @Override
    public void highlight(@NotNull JComponent component2, @NotNull String searchString) {
        if (component2 == null) {
            SpotlightPainter.$$$reportNull$$$0(1);
        }
        if (searchString == null) {
            SpotlightPainter.$$$reportNull$$$0(2);
        }
        this.myGlassPanel.addSpotlight(component2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchString";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/options/newEditor/SpotlightPainter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "highlight";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

