/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.util;

import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OutputWrapper
extends OutputStream {
    @NotNull
    private final ExternalSystemTaskNotificationListener myListener;
    @NotNull
    private final ExternalSystemTaskId myTaskId;
    @Nullable
    private StringBuilder myBuffer;
    private final boolean myStdOut;

    public OutputWrapper(@NotNull ExternalSystemTaskNotificationListener listener2, @NotNull ExternalSystemTaskId taskId, boolean stdOut) {
        if (listener2 == null) {
            OutputWrapper.$$$reportNull$$$0(0);
        }
        if (taskId == null) {
            OutputWrapper.$$$reportNull$$$0(1);
        }
        this.myListener = listener2;
        this.myTaskId = taskId;
        this.myStdOut = stdOut;
    }

    @Override
    public void write(int b) {
        if (this.myBuffer == null) {
            this.myBuffer = new StringBuilder();
        }
        this.myBuffer.append((char)b);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (this.myBuffer == null) {
            this.myBuffer = new StringBuilder();
        }
        this.myBuffer.append(new String(b, off, len, StandardCharsets.UTF_8));
    }

    @Override
    public void flush() {
        this.doFlush();
    }

    private void doFlush() {
        if (this.myBuffer == null) {
            return;
        }
        this.myListener.onTaskOutput(this.myTaskId, this.myBuffer.toString(), this.myStdOut);
        this.myBuffer.setLength(0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "listener";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "taskId";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/externalSystem/util/OutputWrapper";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

