/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeStyle;

import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.PlatformEditorBundle;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.InternalFileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.project.ProjectKt;
import com.intellij.util.LineSeparator;
import java.io.IOException;
import java.nio.file.Path;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractConvertLineSeparatorsAction
extends AnAction
implements DumbAware,
LightEditCompatible {
    private static final Logger LOG = Logger.getInstance(AbstractConvertLineSeparatorsAction.class);
    @NotNull
    private final String mySeparator;

    protected AbstractConvertLineSeparatorsAction(@NotNull Supplier<String> text, @NotNull LineSeparator separator) {
        if (text == null) {
            AbstractConvertLineSeparatorsAction.$$$reportNull$$$0(0);
        }
        if (separator == null) {
            AbstractConvertLineSeparatorsAction.$$$reportNull$$$0(1);
        }
        this(separator + " - " + text.get(), separator.getSeparatorString());
    }

    protected AbstractConvertLineSeparatorsAction(@Nullable String text, @NotNull String separator) {
        if (separator == null) {
            AbstractConvertLineSeparatorsAction.$$$reportNull$$$0(2);
        }
        super(text);
        this.mySeparator = separator;
    }

    public void update(@NotNull AnActionEvent e) {
        DataContext dataContext;
        Project project;
        if (e == null) {
            AbstractConvertLineSeparatorsAction.$$$reportNull$$$0(3);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext = e.getDataContext())) != null) {
            VirtualFile[] virtualFiles = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
            Presentation presentation2 = e.getPresentation();
            if (virtualFiles != null) {
                if (virtualFiles.length == 1) {
                    presentation2.setEnabled(!this.mySeparator.equals(LoadTextUtil.detectLineSeparator(virtualFiles[0], false)));
                } else {
                    presentation2.setEnabled(true);
                }
            } else {
                presentation2.setEnabled(false);
            }
        }
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        DataContext dataContext;
        Project project;
        if (event == null) {
            AbstractConvertLineSeparatorsAction.$$$reportNull$$$0(4);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext = event.getDataContext())) == null) {
            return;
        }
        VirtualFile[] virtualFiles = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        if (virtualFiles == null) {
            return;
        }
        Path directoryStorePath = ProjectKt.getStateStore(project).getDirectoryStorePath();
        final VirtualFile projectVirtualDirectory = directoryStorePath == null ? null : StandardFileSystems.local().findFileByPath(FileUtil.toSystemIndependentName((String)directoryStorePath.toString()));
        final FileTypeRegistry fileTypeManager = FileTypeRegistry.getInstance();
        for (VirtualFile file2 : virtualFiles) {
            VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

                @NotNull
                public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file2) {
                    if (file2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (AbstractConvertLineSeparatorsAction.shouldProcess(file2)) {
                        AbstractConvertLineSeparatorsAction.changeLineSeparators(project, file2, AbstractConvertLineSeparatorsAction.this.mySeparator);
                    }
                    VirtualFileVisitor.Result result2 = file2.isDirectory() && (file2.equals(projectVirtualDirectory) || fileTypeManager.isFileIgnored(file2)) ? SKIP_CHILDREN : CONTINUE;
                    if (result2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return result2;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "file";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/codeStyle/AbstractConvertLineSeparatorsAction$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/codeStyle/AbstractConvertLineSeparatorsAction$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "visitFileEx";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "visitFileEx";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            });
        }
    }

    public static boolean shouldProcess(@NotNull VirtualFile file2) {
        if (file2 == null) {
            AbstractConvertLineSeparatorsAction.$$$reportNull$$$0(5);
        }
        return !file2.isDirectory() && file2.isWritable() && !(file2 instanceof VirtualFileWindow) && !FileTypeRegistry.getInstance().isFileIgnored(file2) && !file2.getFileType().isBinary() && !(file2.getFileType() instanceof InternalFileType);
    }

    public static void changeLineSeparators(@NotNull Project project, @NotNull VirtualFile virtualFile, @NotNull String newSeparator) {
        String currentSeparator;
        FileDocumentManager fileDocumentManager;
        Document document;
        if (project == null) {
            AbstractConvertLineSeparatorsAction.$$$reportNull$$$0(6);
        }
        if (virtualFile == null) {
            AbstractConvertLineSeparatorsAction.$$$reportNull$$$0(7);
        }
        if (newSeparator == null) {
            AbstractConvertLineSeparatorsAction.$$$reportNull$$$0(8);
        }
        if ((document = (fileDocumentManager = FileDocumentManager.getInstance()).getCachedDocument(virtualFile)) != null) {
            fileDocumentManager.saveDocument(document);
        }
        String commandText = StringUtil.isEmpty((String)(currentSeparator = LoadTextUtil.detectLineSeparator(virtualFile, false))) ? PlatformEditorBundle.message((String)"command.name.changed.line.separators.to", (Object[])new Object[]{LineSeparator.fromString((String)newSeparator)}) : String.format("Changed line separators from %s to %s", LineSeparator.fromString((String)currentSeparator), LineSeparator.fromString((String)newSeparator));
        WriteCommandAction.writeCommandAction((Project)project).withName(commandText).run(() -> {
            try {
                LoadTextUtil.changeLineSeparators(project, virtualFile, newSeparator, virtualFile);
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSeparator";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeStyle/AbstractConvertLineSeparatorsAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldProcess";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "changeLineSeparators";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

