/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.ModuleListCellRenderer;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.platform.ModuleAttachProcessor;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.containers.ContainerUtil;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModuleAwareProjectConfigurable<T extends UnnamedConfigurable>
implements SearchableConfigurable,
Configurable.NoScroll {
    @NotNull
    private final Project myProject;
    private final String myDisplayName;
    private final String myHelpTopic;
    private final Map<Module, T> myModuleConfigurables;
    private static final String PROJECT_ITEM_KEY = "thisisnotthemoduleyouarelookingfor";

    public ModuleAwareProjectConfigurable(@NotNull Project project, String displayName, @NonNls String helpTopic) {
        if (project == null) {
            ModuleAwareProjectConfigurable.$$$reportNull$$$0(0);
        }
        this.myModuleConfigurables = new HashMap<Module, T>();
        this.myProject = project;
        this.myDisplayName = displayName;
        this.myHelpTopic = helpTopic;
    }

    @Nls
    public String getDisplayName() {
        return this.myDisplayName;
    }

    public String getHelpTopic() {
        return this.myHelpTopic;
    }

    protected boolean isSuitableForModule(@NotNull Module module) {
        if (module == null) {
            ModuleAwareProjectConfigurable.$$$reportNull$$$0(1);
        }
        return true;
    }

    public JComponent createComponent() {
        T configurable2;
        if (this.myProject.isDefault() && (configurable2 = this.createDefaultProjectConfigurable()) != null) {
            this.myModuleConfigurables.put(null, configurable2);
            return configurable2.createComponent();
        }
        List modules2 = ContainerUtil.filter(ModuleAttachProcessor.getSortedModules(this.myProject), module -> this.isSuitableForModule((Module)module));
        T projectConfigurable = this.createProjectConfigurable();
        if (modules2.size() == 1 && projectConfigurable == null) {
            Module module2 = (Module)modules2.get(0);
            T configurable3 = this.createModuleConfigurable(module2);
            this.myModuleConfigurables.put(module2, configurable3);
            return configurable3.createComponent();
        }
        Splitter splitter = new Splitter(false, 0.25f);
        CollectionListModel listDataModel = new CollectionListModel(modules2);
        final JBList moduleList = new JBList((ListModel)listDataModel);
        new ListSpeedSearch(moduleList, o -> {
            if (o == null) {
                return this.getProjectConfigurableItemName();
            }
            if (o instanceof Module) {
                return ((Module)o).getName();
            }
            return null;
        });
        moduleList.setSelectionMode(0);
        moduleList.setCellRenderer((ListCellRenderer)((Object)new ModuleListCellRenderer(){

            @Override
            public void customize(@NotNull JList<? extends Module> list2, Module module, int index, boolean selected2, boolean hasFocus) {
                if (list2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (module == null) {
                    this.setText(ModuleAwareProjectConfigurable.this.getProjectConfigurableItemName());
                    this.setIcon(ModuleAwareProjectConfigurable.this.getProjectConfigurableItemIcon());
                } else {
                    super.customize(list2, module, index, selected2, hasFocus);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/application/options/ModuleAwareProjectConfigurable$1", "customize"));
            }
        }));
        splitter.setFirstComponent((JComponent)new JBScrollPane((Component)moduleList));
        final CardLayout layout = new CardLayout();
        final JPanel cardPanel = new JPanel(layout);
        splitter.setSecondComponent((JComponent)cardPanel);
        if (projectConfigurable != null) {
            this.myModuleConfigurables.put(null, projectConfigurable);
            JComponent component2 = projectConfigurable.createComponent();
            cardPanel.add((Component)component2, PROJECT_ITEM_KEY);
            listDataModel.add(0, null);
        }
        for (Module module3 : modules2) {
            T configurable4 = this.createModuleConfigurable(module3);
            this.myModuleConfigurables.put(module3, configurable4);
            JComponent component3 = configurable4.createComponent();
            cardPanel.add((Component)component3, module3.getName());
        }
        moduleList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Module value2 = (Module)moduleList.getSelectedValue();
                layout.show(cardPanel, value2 == null ? ModuleAwareProjectConfigurable.PROJECT_ITEM_KEY : value2.getName());
            }
        });
        if (moduleList.getItemsCount() > 0) {
            moduleList.setSelectedIndex(0);
            Module module4 = (Module)listDataModel.getElementAt(0);
            layout.show(cardPanel, module4 == null ? PROJECT_ITEM_KEY : module4.getName());
        }
        return splitter;
    }

    @Nullable
    protected T createDefaultProjectConfigurable() {
        return null;
    }

    @Nullable
    protected T createProjectConfigurable() {
        return null;
    }

    @NotNull
    protected String getProjectConfigurableItemName() {
        String string = this.myProject.getName();
        if (string == null) {
            ModuleAwareProjectConfigurable.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    protected Icon getProjectConfigurableItemIcon() {
        return AllIcons.Nodes.Project;
    }

    @NotNull
    protected abstract T createModuleConfigurable(Module var1);

    public boolean isModified() {
        for (UnnamedConfigurable configurable2 : this.myModuleConfigurables.values()) {
            if (!configurable2.isModified()) continue;
            return true;
        }
        return false;
    }

    public void apply() throws ConfigurationException {
        for (UnnamedConfigurable configurable2 : this.myModuleConfigurables.values()) {
            configurable2.apply();
        }
    }

    public void reset() {
        for (UnnamedConfigurable configurable2 : this.myModuleConfigurables.values()) {
            configurable2.reset();
        }
    }

    public void disposeUIResources() {
        for (UnnamedConfigurable configurable2 : this.myModuleConfigurables.values()) {
            configurable2.disposeUIResources();
        }
        this.myModuleConfigurables.clear();
    }

    @NotNull
    public String getId() {
        String string = this.getClass().getName();
        if (string == null) {
            ModuleAwareProjectConfigurable.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    protected final Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            ModuleAwareProjectConfigurable.$$$reportNull$$$0(4);
        }
        return project;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/ModuleAwareProjectConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/ModuleAwareProjectConfigurable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectConfigurableItemName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isSuitableForModule";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

