/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.mock;

import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.mock.MockFacetEditorTab;
import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorTab;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jdom.Element;

public class MockFacetConfiguration
implements FacetConfiguration {
    private final List<VirtualFile> myRoots = new ArrayList<VirtualFile>();
    private String myData = "";
    private MockFacetEditorTab myEditor;

    public FacetEditorTab[] createEditorTabs(FacetEditorContext editorContext, FacetValidatorsManager validatorsManager) {
        this.myEditor = new MockFacetEditorTab(this);
        return new FacetEditorTab[]{this.myEditor};
    }

    public MockFacetEditorTab getEditor() {
        return this.myEditor;
    }

    public void addRoot(VirtualFile root) {
        this.myRoots.add(root);
    }

    public void removeRoot(VirtualFile root) {
        this.myRoots.remove(root);
    }

    public void setData(String data) {
        this.myData = data;
    }

    public String getData() {
        return this.myData;
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.myData = StringUtil.notNullize((String)element.getAttributeValue("data"));
        List children = element.getChildren("root");
        for (Element child : children) {
            this.myRoots.add(VirtualFileManager.getInstance().findFileByUrl(child.getAttributeValue("url")));
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        if (!this.myData.isEmpty()) {
            element.setAttribute("data", this.myData);
        }
        for (VirtualFile root : this.myRoots) {
            element.addContent(new Element("root").setAttribute("url", root.getUrl()));
        }
    }

    public Collection<VirtualFile> getRoots() {
        return this.myRoots;
    }
}

