/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.parsing;

import com.intellij.lang.ITokenTypeRemapper;
import com.intellij.lang.SyntaxTreeBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.parsing.ParsingContext;
import com.jetbrains.python.parsing.PyParser;
import com.jetbrains.python.parsing.StatementParsing;
import com.jetbrains.python.psi.LanguageLevel;

public class PythonParser {
    protected static final Logger LOGGER = Logger.getInstance((String)PyParser.class.getName());
    protected LanguageLevel myLanguageLevel = LanguageLevel.getDefault();
    private StatementParsing.FUTURE myFutureFlag;

    public void setLanguageLevel(LanguageLevel languageLevel) {
        this.myLanguageLevel = languageLevel;
    }

    public void parseRoot(IElementType root, SyntaxTreeBuilder builder) {
        SyntaxTreeBuilder.Marker rootMarker = builder.mark();
        ParsingContext context = this.createParsingContext(builder, this.myLanguageLevel, this.myFutureFlag);
        StatementParsing statementParser = context.getStatementParser();
        builder.setTokenTypeRemapper((ITokenTypeRemapper)statementParser);
        boolean lastAfterSemicolon = false;
        while (!builder.eof()) {
            context.pushScope(context.emptyParsingScope());
            if (lastAfterSemicolon) {
                statementParser.parseSimpleStatement();
            } else {
                statementParser.parseStatement();
            }
            lastAfterSemicolon = context.getScope().isAfterSemicolon();
            context.popScope();
        }
        rootMarker.done(root);
    }

    protected ParsingContext createParsingContext(SyntaxTreeBuilder builder, LanguageLevel languageLevel, StatementParsing.FUTURE futureFlag) {
        return new ParsingContext(builder, languageLevel, futureFlag);
    }

    public void setFutureFlag(StatementParsing.FUTURE future2) {
        this.myFutureFlag = future2;
    }
}

