/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.navigation;

import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.navigation.RelatedToHtmlFilesContributor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class HtmlGotoRelatedProvider
extends GotoRelatedProvider {
    @NotNull
    public List<? extends GotoRelatedItem> getItems(@NotNull PsiElement context) {
        PsiFile file;
        if (context == null) {
            HtmlGotoRelatedProvider.$$$reportNull$$$0(0);
        }
        if ((file = context.getContainingFile()) == null || !HtmlGotoRelatedProvider.isAvailable(file)) {
            List list = Collections.emptyList();
            if (list == null) {
                HtmlGotoRelatedProvider.$$$reportNull$$$0(1);
            }
            return list;
        }
        List<? extends GotoRelatedItem> list = HtmlGotoRelatedProvider.getRelatedFiles(file);
        if (list == null) {
            HtmlGotoRelatedProvider.$$$reportNull$$$0(2);
        }
        return list;
    }

    private static boolean isAvailable(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            HtmlGotoRelatedProvider.$$$reportNull$$$0(3);
        }
        for (PsiFile file : psiFile.getViewProvider().getAllFiles()) {
            Language language = file.getLanguage();
            if (!language.isKindOf((Language)HTMLLanguage.INSTANCE) && !language.isKindOf((Language)XHTMLLanguage.INSTANCE)) continue;
            return true;
        }
        return false;
    }

    private static List<? extends GotoRelatedItem> getRelatedFiles(@NotNull PsiFile file) {
        if (file == null) {
            HtmlGotoRelatedProvider.$$$reportNull$$$0(4);
        }
        ArrayList<GotoRelatedItem> items = new ArrayList<GotoRelatedItem>();
        for (PsiFile psiFile : file.getViewProvider().getAllFiles()) {
            if (!(psiFile instanceof XmlFile)) continue;
            XmlFile xmlFile = (XmlFile)psiFile;
            for (RelatedToHtmlFilesContributor contributor : RelatedToHtmlFilesContributor.EP_NAME.getExtensionList()) {
                HashSet resultSet = new HashSet();
                contributor.fillRelatedFiles(xmlFile, resultSet);
                for (PsiFile f : resultSet) {
                    items.add(new GotoRelatedItem((PsiElement)f, contributor.getGroupName()));
                }
            }
        }
        return items;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/navigation/HtmlGotoRelatedProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/navigation/HtmlGotoRelatedProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getItems";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRelatedFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

