/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.xml;

import com.intellij.formatting.Block;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.FormattingDocumentModelImpl;
import com.intellij.psi.formatter.PsiBasedFormattingModel;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTokenType;
import org.jetbrains.annotations.Nullable;

public class XmlFormattingModel
extends PsiBasedFormattingModel {
    private static final Logger LOG = Logger.getInstance(XmlFormattingModel.class);

    public XmlFormattingModel(PsiFile file, Block rootBlock, FormattingDocumentModelImpl documentModel) {
        super(file, rootBlock, documentModel);
    }

    protected String replaceWithPsiInLeaf(TextRange textRange, String whiteSpace, ASTNode leafElement) {
        if (!this.myCanModifyAllWhiteSpaces) {
            if (leafElement.getElementType() == TokenType.WHITE_SPACE) {
                return null;
            }
            LOG.assertTrue(leafElement.getPsi().isValid());
            ASTNode prevNode = TreeUtil.prevLeaf((ASTNode)leafElement);
            if (prevNode != null) {
                IElementType type = prevNode.getElementType();
                if (type == TokenType.WHITE_SPACE) {
                    String text = prevNode.getText();
                    String cdataStartMarker = "<![CDATA[";
                    int cdataPos = text.indexOf("<![CDATA[");
                    if (cdataPos != -1 && !whiteSpace.contains("<![CDATA[") && (whiteSpace = XmlFormattingModel.mergeWsWithCdataMarker(whiteSpace, text, cdataPos)) == null) {
                        return null;
                    }
                    type = (prevNode = TreeUtil.prevLeaf((ASTNode)prevNode)) != null ? prevNode.getElementType() : null;
                }
                String cdataEndMarker = "]]>";
                if (type == XmlTokenType.XML_CDATA_END && !whiteSpace.contains("]]>")) {
                    ASTNode at = this.findElementAt(prevNode.getStartOffset());
                    if (at != null && at.getPsi() instanceof PsiWhiteSpace) {
                        String s = at.getText();
                        int cdataEndPos = s.indexOf("]]>");
                        whiteSpace = XmlFormattingModel.mergeWsWithCdataMarker(whiteSpace, s, cdataEndPos);
                        leafElement = at;
                    } else {
                        whiteSpace = null;
                    }
                    if (whiteSpace == null) {
                        return null;
                    }
                }
            }
        }
        FormatterUtil.replaceWhiteSpace((String)whiteSpace, (ASTNode)leafElement, (IElementType)TokenType.WHITE_SPACE, (TextRange)textRange);
        return whiteSpace;
    }

    @Nullable
    private static String mergeWsWithCdataMarker(String whiteSpace, String s, int cdataPos) {
        int firstCrInGeneratedWs = whiteSpace.indexOf(10);
        int secondCrInGeneratedWs = firstCrInGeneratedWs != -1 ? whiteSpace.indexOf(10, firstCrInGeneratedWs + 1) : -1;
        int firstCrInPreviousWs = s.indexOf(10);
        int secondCrInPreviousWs = firstCrInPreviousWs != -1 ? s.indexOf(10, firstCrInPreviousWs + 1) : -1;
        boolean knowHowToModifyCData = false;
        if (secondCrInPreviousWs != -1 && secondCrInGeneratedWs != -1 && cdataPos > firstCrInPreviousWs && cdataPos < secondCrInPreviousWs) {
            whiteSpace = whiteSpace.substring(0, secondCrInGeneratedWs) + s.substring(firstCrInPreviousWs + 1, secondCrInPreviousWs) + whiteSpace.substring(secondCrInGeneratedWs);
            knowHowToModifyCData = true;
        }
        if (!knowHowToModifyCData) {
            whiteSpace = null;
        }
        return whiteSpace;
    }
}

