/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.BasicInsertHandler;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.XmlCompletionContributor;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ProcessingContext;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NotNull;

public class DtdCompletionContributor
extends CompletionContributor {
    private static final String[] KEYWORDS = new String[]{"#PCDATA", "#IMPLIED", "#REQUIRED", "#FIXED", "<!ATTLIST", "<!ELEMENT", "<!NOTATION", "INCLUDE", "IGNORE", "CDATA", "ID", "IDREF", "EMPTY", "ANY", "IDREFS", "ENTITIES", "ENTITY", "<!ENTITY", "NMTOKEN", "NMTOKENS", "SYSTEM", "PUBLIC"};
    private static final InsertHandler<LookupElement> INSERT_HANDLER = new BasicInsertHandler<LookupElement>(){

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            if (context == null) {
                1.$$$reportNull$$$0(0);
            }
            if (item == null) {
                1.$$$reportNull$$$0(1);
            }
            super.handleInsert(context, item);
            if (item.getObject().toString().startsWith("<!")) {
                context.commitDocument();
                int caretOffset = context.getEditor().getCaretModel().getOffset();
                PsiElement tag = PsiTreeUtil.getParentOfType((PsiElement)context.getFile().findElementAt(caretOffset), PsiNamedElement.class);
                if (tag == null) {
                    context.getEditor().getDocument().insertString(caretOffset, (CharSequence)" >");
                    context.getEditor().getCaretModel().moveToOffset(caretOffset + 1);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/completion/DtdCompletionContributor$1";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    public DtdCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement(), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
                PsiElement position;
                PsiElement prev;
                if (parameters == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    2.$$$reportNull$$$0(2);
                }
                if ((prev = PsiTreeUtil.prevVisibleLeaf((PsiElement)(position = parameters.getPosition()))) != null && DtdCompletionContributor.hasDtdKeywordCompletion(prev)) {
                    DtdCompletionContributor.addKeywordCompletions(result.withPrefixMatcher(DtdCompletionContributor.keywordPrefix(position, result.getPrefixMatcher().getPrefix())));
                }
                if (prev != null && prev.textMatches((CharSequence)"%")) {
                    DtdCompletionContributor.addEntityCompletions(result, position);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInsight/completion/DtdCompletionContributor$2";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    private static String keywordPrefix(@NotNull PsiElement position, @NotNull String prefix) {
        PsiElement prevLeaf;
        PsiElement prevPrevLeaf;
        if (position == null) {
            DtdCompletionContributor.$$$reportNull$$$0(0);
        }
        if (prefix == null) {
            DtdCompletionContributor.$$$reportNull$$$0(1);
        }
        PsiElement psiElement = prevPrevLeaf = (prevLeaf = PsiTreeUtil.prevLeaf((PsiElement)position)) != null ? PsiTreeUtil.prevLeaf((PsiElement)prevLeaf) : null;
        if (prevLeaf != null) {
            String prevLeafText = prevLeaf.getText();
            if ("#".equals(prevLeafText)) {
                prefix = "#" + prefix;
            } else if ("!".equals(prevLeafText) && prevPrevLeaf != null && "<".equals(prevPrevLeaf.getText())) {
                prefix = "<!" + prefix;
            }
        }
        String string = prefix;
        if (string == null) {
            DtdCompletionContributor.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static void addKeywordCompletions(@NotNull CompletionResultSet result) {
        if (result == null) {
            DtdCompletionContributor.$$$reportNull$$$0(3);
        }
        for (String keyword : KEYWORDS) {
            result.addElement((LookupElement)LookupElementBuilder.create((String)keyword).withInsertHandler(INSERT_HANDLER));
        }
    }

    private static void addEntityCompletions(final @NotNull CompletionResultSet result, PsiElement position) {
        if (result == null) {
            DtdCompletionContributor.$$$reportNull$$$0(4);
        }
        PsiElementProcessor processor = new PsiElementProcessor(){

            public boolean execute(@NotNull PsiElement element) {
                XmlEntityDecl xmlEntityDecl;
                String name;
                if (element == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (element instanceof XmlEntityDecl && (name = (xmlEntityDecl = (XmlEntityDecl)element).getName()) != null && xmlEntityDecl.isInternalReference()) {
                    result.addElement((LookupElement)LookupElementBuilder.create((String)name).withInsertHandler((InsertHandler)XmlCompletionContributor.ENTITY_INSERT_HANDLER));
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/completion/DtdCompletionContributor$3", "execute"));
            }
        };
        XmlUtil.processXmlElements((XmlElement)((XmlFile)position.getContainingFile().getOriginalFile()), (PsiElementProcessor<? super PsiElement>)processor, true);
    }

    private static boolean hasDtdKeywordCompletion(@NotNull PsiElement prev) {
        if (prev == null) {
            DtdCompletionContributor.$$$reportNull$$$0(5);
        }
        return prev.textMatches((CharSequence)"#") || prev.textMatches((CharSequence)"!") || prev.textMatches((CharSequence)"(") || prev.textMatches((CharSequence)",") || prev.textMatches((CharSequence)"|") || prev.textMatches((CharSequence)"[") || prev.getNode().getElementType() == XmlTokenType.XML_NAME;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/DtdCompletionContributor";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prev";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/DtdCompletionContributor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "keywordPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "keywordPrefix";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addKeywordCompletions";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addEntityCompletions";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasDtdKeywordCompletion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

