/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.RefGroup;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsLogStandardColors;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import com.intellij.vcs.log.impl.SimpleRefGroup;
import com.intellij.vcs.log.impl.SimpleRefType;
import com.intellij.vcs.log.impl.SingletonRefGroup;
import com.intellij.vcs.log.util.VcsLogUtil;
import git4idea.GitRemoteBranch;
import git4idea.branch.GitBranchType;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitBranchManager;
import java.awt.Color;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitRefManager
implements VcsLogRefManager {
    private static final JBColor HEAD_COLOR = JBColor.namedColor((String)"VersionControl.GitLog.headIconColor", (Color)VcsLogStandardColors.Refs.TIP);
    private static final JBColor LOCAL_BRANCH_COLOR = JBColor.namedColor((String)"VersionControl.GitLog.localBranchIconColor", (Color)VcsLogStandardColors.Refs.BRANCH);
    private static final JBColor REMOTE_BRANCH_COLOR = JBColor.namedColor((String)"VersionControl.GitLog.remoteBranchIconColor", (Color)VcsLogStandardColors.Refs.BRANCH_REF);
    private static final JBColor TAG_COLOR = JBColor.namedColor((String)"VersionControl.GitLog.tagIconColor", (Color)VcsLogStandardColors.Refs.TAG);
    private static final JBColor OTHER_COLOR = JBColor.namedColor((String)"VersionControl.GitLog.otherIconColor", (Color)VcsLogStandardColors.Refs.TAG);
    public static final VcsRefType HEAD = new SimpleRefType("HEAD", true, (Color)HEAD_COLOR);
    public static final VcsRefType LOCAL_BRANCH = new SimpleRefType("LOCAL_BRANCH", true, (Color)LOCAL_BRANCH_COLOR);
    public static final VcsRefType REMOTE_BRANCH = new SimpleRefType("REMOTE_BRANCH", true, (Color)REMOTE_BRANCH_COLOR);
    public static final VcsRefType TAG = new SimpleRefType("TAG", false, (Color)TAG_COLOR);
    public static final VcsRefType OTHER = new SimpleRefType("OTHER", false, (Color)OTHER_COLOR);
    private static final List<VcsRefType> REF_TYPE_INDEX = Arrays.asList(HEAD, LOCAL_BRANCH, REMOTE_BRANCH, TAG, OTHER);
    public static final String MASTER = "master";
    public static final String ORIGIN_MASTER = "origin/master";
    public static final String ORIGIN_MASTER_REF = "refs/remotes/origin/master";
    private static final Logger LOG = Logger.getInstance(GitRefManager.class);
    private static final String REMOTE_TABLE_SEPARATOR = " & ";
    private static final String SEPARATOR = "/";
    @NotNull
    private final RepositoryManager<GitRepository> myRepositoryManager;
    @NotNull
    private final Comparator<VcsRef> myLabelsComparator;
    @NotNull
    private final Comparator<VcsRef> myBranchLayoutComparator;
    @NotNull
    private final GitBranchManager myBranchManager;

    public GitRefManager(@NotNull Project project, @NotNull RepositoryManager<GitRepository> repositoryManager) {
        if (project == null) {
            GitRefManager.$$$reportNull$$$0(0);
        }
        if (repositoryManager == null) {
            GitRefManager.$$$reportNull$$$0(1);
        }
        this.myRepositoryManager = repositoryManager;
        this.myBranchLayoutComparator = new GitBranchLayoutComparator();
        this.myLabelsComparator = new GitLabelComparator();
        this.myBranchManager = (GitBranchManager)((Object)ServiceManager.getService((Project)project, GitBranchManager.class));
    }

    @NotNull
    public Comparator<VcsRef> getLabelsOrderComparator() {
        Comparator<VcsRef> comparator = this.myLabelsComparator;
        if (comparator == null) {
            GitRefManager.$$$reportNull$$$0(2);
        }
        return comparator;
    }

    @NotNull
    public Comparator<VcsRef> getBranchLayoutComparator() {
        Comparator<VcsRef> comparator = this.myBranchLayoutComparator;
        if (comparator == null) {
            GitRefManager.$$$reportNull$$$0(3);
        }
        return comparator;
    }

    @NotNull
    public List<RefGroup> groupForBranchFilter(@NotNull Collection<? extends VcsRef> refs) {
        if (refs == null) {
            GitRefManager.$$$reportNull$$$0(4);
        }
        ArrayList<SingletonRefGroup> simpleGroups = new ArrayList<SingletonRefGroup>();
        ArrayList<VcsRef> localBranches = new ArrayList<VcsRef>();
        MultiMap remoteRefGroups = MultiMap.create();
        MultiMap<VirtualFile, VcsRef> refsByRoot = GitRefManager.groupRefsByRoot(refs);
        for (Map.Entry entry : refsByRoot.entrySet()) {
            VirtualFile root = (VirtualFile)entry.getKey();
            List refsInRoot = ContainerUtil.sorted((Collection)((Collection)entry.getValue()), this.myLabelsComparator);
            GitRepository repository = (GitRepository)this.myRepositoryManager.getRepositoryForRootQuick(root);
            if (repository == null) {
                LOG.warn("No repository for root: " + root);
                continue;
            }
            Set<String> locals = GitRefManager.getLocalBranches(repository);
            Map<String, GitRemote> allRemote = GitRefManager.getAllRemoteBranches(repository);
            for (VcsRef ref : refsInRoot) {
                if (ref.getType() == HEAD) {
                    simpleGroups.add(new SingletonRefGroup(ref));
                    continue;
                }
                String refName = ref.getName();
                if (locals.contains(refName)) {
                    localBranches.add(ref);
                    continue;
                }
                if (allRemote.containsKey(refName)) {
                    remoteRefGroups.putValue((Object)allRemote.get(refName), (Object)ref);
                    continue;
                }
                LOG.debug("Didn't find ref neither in local nor in remote branches: " + ref);
            }
        }
        ArrayList<RefGroup> result2 = new ArrayList<RefGroup>();
        result2.addAll(simpleGroups);
        if (!localBranches.isEmpty()) {
            result2.add((RefGroup)new SimpleRefGroup(GitBundle.message("git.log.refGroup.local", new Object[0]), localBranches, false));
        }
        for (Map.Entry entry : remoteRefGroups.entrySet()) {
            result2.add(new RemoteRefGroup((GitRemote)entry.getKey(), (Collection)entry.getValue()));
        }
        ArrayList<RefGroup> arrayList = result2;
        if (arrayList == null) {
            GitRefManager.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    public List<RefGroup> groupForTable(@NotNull Collection<? extends VcsRef> references, boolean compact, boolean showTagNames) {
        GitRepository repository;
        if (references == null) {
            GitRefManager.$$$reportNull$$$0(6);
        }
        List sortedReferences = ContainerUtil.sorted(references, this.myLabelsComparator);
        MultiMap groupedRefs = ContainerUtil.groupBy((Iterable)sortedReferences, VcsRef::getType);
        ArrayList<RefGroup> result2 = new ArrayList<RefGroup>();
        if (groupedRefs.isEmpty()) {
            ArrayList<RefGroup> arrayList = result2;
            if (arrayList == null) {
                GitRefManager.$$$reportNull$$$0(7);
            }
            return arrayList;
        }
        VcsRef head = null;
        Map.Entry firstGroup = Objects.requireNonNull((Map.Entry)ContainerUtil.getFirstItem((Collection)groupedRefs.entrySet()));
        if (((VcsRefType)firstGroup.getKey()).equals(HEAD)) {
            head = Objects.requireNonNull((VcsRef)ContainerUtil.getFirstItem((Collection)((Collection)firstGroup.getValue())));
            groupedRefs.remove((Object)HEAD, (Object)head);
        }
        if ((repository = this.getRepository(references)) != null) {
            result2.addAll(GitRefManager.getTrackedRefs((MultiMap<VcsRefType, VcsRef>)groupedRefs, repository));
        }
        result2.forEach(refGroup -> {
            groupedRefs.remove((Object)LOCAL_BRANCH, (Object)((VcsRef)refGroup.getRefs().get(0)));
            groupedRefs.remove((Object)REMOTE_BRANCH, (Object)((VcsRef)refGroup.getRefs().get(1)));
        });
        SimpleRefGroup.buildGroups((MultiMap)groupedRefs, (boolean)compact, (boolean)showTagNames, result2);
        if (head != null) {
            if (repository != null && !repository.isOnBranch()) {
                result2.add(0, (RefGroup)new SimpleRefGroup("!", Collections.singletonList(head)));
            } else if (!result2.isEmpty()) {
                RefGroup first = Objects.requireNonNull((RefGroup)ContainerUtil.getFirstItem(result2));
                first.getRefs().add(0, head);
            } else {
                result2.add(0, (RefGroup)new SimpleRefGroup("", Collections.singletonList(head)));
            }
        }
        ArrayList<RefGroup> arrayList = result2;
        if (arrayList == null) {
            GitRefManager.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    private static List<RefGroup> getTrackedRefs(@NotNull MultiMap<VcsRefType, VcsRef> groupedRefs, @NotNull GitRepository repository) {
        if (groupedRefs == null) {
            GitRefManager.$$$reportNull$$$0(9);
        }
        if (repository == null) {
            GitRefManager.$$$reportNull$$$0(10);
        }
        ArrayList<RefGroup> result2 = new ArrayList<RefGroup>();
        Collection locals = groupedRefs.get((Object)LOCAL_BRANCH);
        Collection remotes = groupedRefs.get((Object)REMOTE_BRANCH);
        for (VcsRef localRef : locals) {
            SimpleRefGroup group = GitRefManager.createTrackedGroup(repository, remotes, localRef);
            if (group == null) continue;
            result2.add((RefGroup)group);
        }
        ArrayList<RefGroup> arrayList = result2;
        if (arrayList == null) {
            GitRefManager.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @Nullable
    private static SimpleRefGroup createTrackedGroup(@NotNull GitRepository repository, @NotNull Collection<? extends VcsRef> references, @NotNull VcsRef localRef) {
        VcsRef trackedRef;
        if (repository == null) {
            GitRefManager.$$$reportNull$$$0(12);
        }
        if (references == null) {
            GitRefManager.$$$reportNull$$$0(13);
        }
        if (localRef == null) {
            GitRefManager.$$$reportNull$$$0(14);
        }
        List remoteBranches = ContainerUtil.filter(references, ref -> ref.getType().equals(REMOTE_BRANCH));
        GitBranchTrackInfo trackInfo = (GitBranchTrackInfo)ContainerUtil.find(repository.getBranchTrackInfos(), info -> info.getLocalBranch().getName().equals(localRef.getName()));
        if (trackInfo != null && (trackedRef = (VcsRef)ContainerUtil.find((Iterable)remoteBranches, ref -> ref.getName().equals(trackInfo.getRemoteBranch().getName()))) != null) {
            return new SimpleRefGroup(trackInfo.getRemote().getName() + REMOTE_TABLE_SEPARATOR + localRef.getName(), (List)ContainerUtil.newArrayList((Object[])new VcsRef[]{localRef, trackedRef}));
        }
        List trackingCandidates = ContainerUtil.filter((Collection)remoteBranches, ref -> ref.getName().endsWith(SEPARATOR + localRef.getName()));
        for (GitRemote remote : repository.getRemotes()) {
            for (VcsRef candidate : trackingCandidates) {
                if (!candidate.getName().equals(remote.getName() + SEPARATOR + localRef.getName())) continue;
                return new SimpleRefGroup(remote.getName() + REMOTE_TABLE_SEPARATOR + localRef.getName(), (List)ContainerUtil.newArrayList((Object[])new VcsRef[]{localRef, candidate}));
            }
        }
        return null;
    }

    @Nullable
    private GitRepository getRepository(@NotNull Collection<? extends VcsRef> references) {
        if (references == null) {
            GitRefManager.$$$reportNull$$$0(15);
        }
        if (references.isEmpty()) {
            return null;
        }
        VcsRef ref = Objects.requireNonNull((VcsRef)ContainerUtil.getFirstItem(references));
        GitRepository repository = this.getRepository(ref);
        if (repository == null) {
            LOG.warn("No repository for root: " + ref.getRoot());
        }
        return repository;
    }

    public void serialize(@NotNull DataOutput out, @NotNull VcsRefType type) throws IOException {
        if (out == null) {
            GitRefManager.$$$reportNull$$$0(16);
        }
        if (type == null) {
            GitRefManager.$$$reportNull$$$0(17);
        }
        out.writeInt(REF_TYPE_INDEX.indexOf(type));
    }

    @NotNull
    public VcsRefType deserialize(@NotNull DataInput in) throws IOException {
        int id;
        if (in == null) {
            GitRefManager.$$$reportNull$$$0(18);
        }
        if ((id = in.readInt()) < 0 || id > REF_TYPE_INDEX.size() - 1) {
            throw new IOException("Reference type by id " + id + " does not exist");
        }
        VcsRefType vcsRefType = REF_TYPE_INDEX.get(id);
        if (vcsRefType == null) {
            GitRefManager.$$$reportNull$$$0(19);
        }
        return vcsRefType;
    }

    @NotNull
    private static GitBranchType getBranchType(@NotNull VcsRef reference) {
        if (reference == null) {
            GitRefManager.$$$reportNull$$$0(20);
        }
        GitBranchType gitBranchType = reference.getType().equals(LOCAL_BRANCH) ? GitBranchType.LOCAL : GitBranchType.REMOTE;
        if (gitBranchType == null) {
            GitRefManager.$$$reportNull$$$0(21);
        }
        return gitBranchType;
    }

    @Nullable
    private GitRepository getRepository(@NotNull VcsRef reference) {
        if (reference == null) {
            GitRefManager.$$$reportNull$$$0(22);
        }
        return (GitRepository)this.myRepositoryManager.getRepositoryForRootQuick(reference.getRoot());
    }

    public boolean isFavorite(@NotNull VcsRef reference) {
        if (reference == null) {
            GitRefManager.$$$reportNull$$$0(23);
        }
        if (reference.getType().equals(HEAD)) {
            return true;
        }
        if (!reference.getType().isBranch()) {
            return false;
        }
        return this.myBranchManager.isFavorite(GitRefManager.getBranchType(reference), this.getRepository(reference), reference.getName());
    }

    public void setFavorite(@NotNull VcsRef reference, boolean favorite) {
        if (reference == null) {
            GitRefManager.$$$reportNull$$$0(24);
        }
        if (reference.getType().equals(HEAD)) {
            return;
        }
        if (!reference.getType().isBranch()) {
            return;
        }
        this.myBranchManager.setFavorite(GitRefManager.getBranchType(reference), this.getRepository(reference), reference.getName(), favorite);
    }

    private static Set<String> getLocalBranches(GitRepository repository) {
        return ContainerUtil.map2Set(repository.getBranches().getLocalBranches(), branch -> branch.getName());
    }

    @NotNull
    private static Map<String, GitRemote> getAllRemoteBranches(@NotNull GitRepository repository) {
        if (repository == null) {
            GitRefManager.$$$reportNull$$$0(25);
        }
        HashSet<GitRemoteBranch> all = new HashSet<GitRemoteBranch>(repository.getBranches().getRemoteBranches());
        HashMap<String, GitRemote> allRemote = new HashMap<String, GitRemote>();
        for (GitRemoteBranch remoteBranch : all) {
            allRemote.put(remoteBranch.getName(), remoteBranch.getRemote());
        }
        HashMap<String, GitRemote> hashMap = allRemote;
        if (hashMap == null) {
            GitRefManager.$$$reportNull$$$0(26);
        }
        return hashMap;
    }

    @NotNull
    private static MultiMap<VirtualFile, VcsRef> groupRefsByRoot(@NotNull Iterable<? extends VcsRef> refs) {
        if (refs == null) {
            GitRefManager.$$$reportNull$$$0(27);
        }
        MultiMap grouped = MultiMap.create();
        for (VcsRef vcsRef : refs) {
            grouped.putValue((Object)vcsRef.getRoot(), (Object)vcsRef);
        }
        MultiMap multiMap = grouped;
        if (multiMap == null) {
            GitRefManager.$$$reportNull$$$0(28);
        }
        return multiMap;
    }

    @NotNull
    public static VcsRefType getRefType(@NotNull String refName) {
        if (refName == null) {
            GitRefManager.$$$reportNull$$$0(29);
        }
        if (refName.startsWith("refs/heads/")) {
            VcsRefType vcsRefType = LOCAL_BRANCH;
            if (vcsRefType == null) {
                GitRefManager.$$$reportNull$$$0(30);
            }
            return vcsRefType;
        }
        if (refName.startsWith("refs/remotes/")) {
            VcsRefType vcsRefType = REMOTE_BRANCH;
            if (vcsRefType == null) {
                GitRefManager.$$$reportNull$$$0(31);
            }
            return vcsRefType;
        }
        if (refName.startsWith("refs/tags/")) {
            VcsRefType vcsRefType = TAG;
            if (vcsRefType == null) {
                GitRefManager.$$$reportNull$$$0(32);
            }
            return vcsRefType;
        }
        if (refName.startsWith("HEAD")) {
            VcsRefType vcsRefType = HEAD;
            if (vcsRefType == null) {
                GitRefManager.$$$reportNull$$$0(33);
            }
            return vcsRefType;
        }
        VcsRefType vcsRefType = OTHER;
        if (vcsRefType == null) {
            GitRefManager.$$$reportNull$$$0(34);
        }
        return vcsRefType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 19: 
            case 21: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 19: 
            case 21: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryManager";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 19: 
            case 21: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/log/GitRefManager";
                break;
            }
            case 4: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 6: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupedRefs";
                break;
            }
            case 10: 
            case 12: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localRef";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
            case 20: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/log/GitRefManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabelsOrderComparator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranchLayoutComparator";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "groupForBranchFilter";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "groupForTable";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTrackedRefs";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranchType";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllRemoteBranches";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "groupRefsByRoot";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 19: 
            case 21: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "groupForBranchFilter";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "groupForTable";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTrackedRefs";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createTrackedGroup";
                break;
            }
            case 15: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getRepository";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getBranchType";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isFavorite";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setFavorite";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getAllRemoteBranches";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "groupRefsByRoot";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getRefType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 19: 
            case 21: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class GitRefComparator
    implements Comparator<VcsRef> {
        private GitRefComparator() {
        }

        @Override
        public int compare(@NotNull VcsRef ref1, @NotNull VcsRef ref2) {
            int power2;
            int power1;
            if (ref1 == null) {
                GitRefComparator.$$$reportNull$$$0(0);
            }
            if (ref2 == null) {
                GitRefComparator.$$$reportNull$$$0(1);
            }
            if ((power1 = ArrayUtil.find((Object[])this.getOrderedTypes(), (Object)((Object)GitRefComparator.getType(ref1)))) != (power2 = ArrayUtil.find((Object[])this.getOrderedTypes(), (Object)((Object)GitRefComparator.getType(ref2))))) {
                return power1 - power2;
            }
            int namesComparison = ref1.getName().compareTo(ref2.getName());
            if (namesComparison != 0) {
                return namesComparison;
            }
            return VcsLogUtil.compareRoots((VirtualFile)ref1.getRoot(), (VirtualFile)ref2.getRoot());
        }

        protected abstract RefType[] getOrderedTypes();

        @NotNull
        private static RefType getType(@NotNull VcsRef ref) {
            VcsRefType type;
            if (ref == null) {
                GitRefComparator.$$$reportNull$$$0(2);
            }
            if ((type = ref.getType()) == HEAD) {
                RefType refType = RefType.HEAD;
                if (refType == null) {
                    GitRefComparator.$$$reportNull$$$0(3);
                }
                return refType;
            }
            if (type == TAG) {
                RefType refType = RefType.TAG;
                if (refType == null) {
                    GitRefComparator.$$$reportNull$$$0(4);
                }
                return refType;
            }
            if (type == LOCAL_BRANCH) {
                if (ref.getName().equals(GitRefManager.MASTER)) {
                    RefType refType = RefType.MASTER;
                    if (refType == null) {
                        GitRefComparator.$$$reportNull$$$0(5);
                    }
                    return refType;
                }
                RefType refType = RefType.LOCAL_BRANCH;
                if (refType == null) {
                    GitRefComparator.$$$reportNull$$$0(6);
                }
                return refType;
            }
            if (type == REMOTE_BRANCH) {
                if (ref.getName().equals(GitRefManager.ORIGIN_MASTER)) {
                    RefType refType = RefType.ORIGIN_MASTER;
                    if (refType == null) {
                        GitRefComparator.$$$reportNull$$$0(7);
                    }
                    return refType;
                }
                RefType refType = RefType.REMOTE_BRANCH;
                if (refType == null) {
                    GitRefComparator.$$$reportNull$$$0(8);
                }
                return refType;
            }
            RefType refType = RefType.OTHER;
            if (refType == null) {
                GitRefComparator.$$$reportNull$$$0(9);
            }
            return refType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref2";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/log/GitRefManager$GitRefComparator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/log/GitRefManager$GitRefComparator";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "compare";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getType";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class GitBranchLayoutComparator
    extends GitRefComparator {
        private static final RefType[] ORDERED_TYPES = new RefType[]{RefType.ORIGIN_MASTER, RefType.REMOTE_BRANCH, RefType.MASTER, RefType.LOCAL_BRANCH, RefType.TAG, RefType.HEAD, RefType.OTHER};

        private GitBranchLayoutComparator() {
        }

        @Override
        protected RefType[] getOrderedTypes() {
            return ORDERED_TYPES;
        }
    }

    private static class GitLabelComparator
    extends GitRefComparator {
        private static final RefType[] ORDERED_TYPES = new RefType[]{RefType.HEAD, RefType.MASTER, RefType.ORIGIN_MASTER, RefType.LOCAL_BRANCH, RefType.REMOTE_BRANCH, RefType.TAG, RefType.OTHER};

        private GitLabelComparator() {
        }

        @Override
        protected RefType[] getOrderedTypes() {
            return ORDERED_TYPES;
        }
    }

    private class RemoteRefGroup
    implements RefGroup {
        private final GitRemote myRemote;
        private final Collection<? extends VcsRef> myBranches;

        RemoteRefGroup(GitRemote remote, Collection<? extends VcsRef> branches2) {
            this.myRemote = remote;
            this.myBranches = branches2;
        }

        public boolean isExpanded() {
            return false;
        }

        @NotNull
        public String getName() {
            String string = this.myRemote.getName() + "/...";
            if (string == null) {
                RemoteRefGroup.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public List<VcsRef> getRefs() {
            List list = ContainerUtil.sorted(this.myBranches, GitRefManager.this.getLabelsOrderComparator());
            if (list == null) {
                RemoteRefGroup.$$$reportNull$$$0(1);
            }
            return list;
        }

        @NotNull
        public List<Color> getColors() {
            List<Color> list = Collections.singletonList(VcsLogStandardColors.Refs.BRANCH_REF);
            if (list == null) {
                RemoteRefGroup.$$$reportNull$$$0(2);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "git4idea/log/GitRefManager$RemoteRefGroup";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRefs";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColors";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    protected static enum RefType {
        OTHER,
        HEAD,
        TAG,
        LOCAL_BRANCH,
        MASTER,
        REMOTE_BRANCH,
        ORIGIN_MASTER;

    }
}

