/*
 * Decompiled with CFR 0.152.
 */
package org.cef.jdk;

import java.awt.Component;
import java.awt.Window;
import java.awt.peer.WindowPeer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import javax.swing.SwingUtilities;
import org.cef.OS;
import sun.awt.AWTAccessor;

public class JdkEx {

    public static class WindowHandleAccessor {
        private static final Method mGetWindowHandle;

        public static long getWindowHandle(Component comp) {
            if (comp == null) {
                return 0L;
            }
            if (!(comp instanceof Window)) {
                comp = SwingUtilities.getWindowAncestor(comp);
            }
            WindowPeer peer = (WindowPeer)AWTAccessor.getComponentAccessor().getPeer(comp);
            try {
                return (Long)mGetWindowHandle.invoke((Object)peer, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                return 0L;
            }
        }

        public static boolean isEnabled() {
            return OS.isMacintosh() && mGetWindowHandle != null;
        }

        static {
            Method m;
            try {
                m = WindowPeer.class.getDeclaredMethod("getWindowHandle", new Class[0]);
                m.setAccessible(true);
            }
            catch (NoSuchMethodException ignore) {
                throw new RuntimeException("jcef: failed to retrieve platform window handle");
            }
            mGetWindowHandle = m;
        }
    }

    public static class InvokeOnToolkitHelperAccessor {
        private static final Method mInvoke;

        public static <T> T invokeAndBlock(Callable<T> callback, T defValue) {
            if (!InvokeOnToolkitHelperAccessor.isEnabled()) {
                try {
                    return callback.call();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                return (T)mInvoke.invoke(null, callback);
            }
            catch (IllegalAccessException | InvocationTargetException ignore) {
                return defValue;
            }
        }

        public static boolean isEnabled() {
            return OS.isMacintosh() && mInvoke != null;
        }

        static {
            Method m = null;
            try {
                Class<?> c = Class.forName("sun.awt.InvokeOnToolkitHelper");
                m = c.getDeclaredMethod("invokeAndBlock", Callable.class);
                m.setAccessible(true);
            }
            catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
                // empty catch block
            }
            mInvoke = m;
        }
    }
}

