/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalChangesUnderRoots {
    private final ChangeListManager myChangeManager;
    private final ProjectLevelVcsManager myVcsManager;

    public LocalChangesUnderRoots(@NotNull ChangeListManager changeListManager, @NotNull ProjectLevelVcsManager projectLevelVcsManager) {
        if (changeListManager == null) {
            LocalChangesUnderRoots.$$$reportNull$$$0(0);
        }
        if (projectLevelVcsManager == null) {
            LocalChangesUnderRoots.$$$reportNull$$$0(1);
        }
        this.myChangeManager = changeListManager;
        this.myVcsManager = projectLevelVcsManager;
    }

    @NotNull
    public Map<String, Map<VirtualFile, Collection<Change>>> getChangesByLists(@NotNull Collection<? extends VirtualFile> rootsToSave) {
        if (rootsToSave == null) {
            LocalChangesUnderRoots.$$$reportNull$$$0(2);
        }
        HashMap<String, Map<VirtualFile, Collection<Change>>> result2 = new HashMap<String, Map<VirtualFile, Collection<Change>>>();
        for (LocalChangeList list : this.myChangeManager.getChangeListsCopy()) {
            result2.put(list.getName(), this.groupChanges(rootsToSave, list.getChanges()));
        }
        HashMap<String, Map<VirtualFile, Collection<Change>>> hashMap = result2;
        if (hashMap == null) {
            LocalChangesUnderRoots.$$$reportNull$$$0(3);
        }
        return hashMap;
    }

    @NotNull
    public Map<VirtualFile, Collection<Change>> getChangesUnderRoots(@NotNull Collection<? extends VirtualFile> rootsToSave) {
        if (rootsToSave == null) {
            LocalChangesUnderRoots.$$$reportNull$$$0(4);
        }
        return this.groupChanges(rootsToSave, this.myChangeManager.getAllChanges());
    }

    @NotNull
    private Map<VirtualFile, Collection<Change>> groupChanges(@NotNull Collection<? extends VirtualFile> rootsToSave, @NotNull Collection<? extends Change> allChanges) {
        if (rootsToSave == null) {
            LocalChangesUnderRoots.$$$reportNull$$$0(5);
        }
        if (allChanges == null) {
            LocalChangesUnderRoots.$$$reportNull$$$0(6);
        }
        HashMap<VirtualFile, Collection<Change>> result2 = new HashMap<VirtualFile, Collection<Change>>();
        for (Change change : allChanges) {
            VirtualFile root = this.getRootForChange(change);
            if (root == null || !rootsToSave.contains(root)) continue;
            Collection changes = result2.computeIfAbsent(root, key -> new HashSet());
            changes.add(change);
        }
        HashMap<VirtualFile, Collection<Change>> hashMap = result2;
        if (hashMap == null) {
            LocalChangesUnderRoots.$$$reportNull$$$0(7);
        }
        return hashMap;
    }

    @Nullable
    private VirtualFile getRootForChange(@NotNull Change change) {
        if (change == null) {
            LocalChangesUnderRoots.$$$reportNull$$$0(8);
        }
        FilePath bPath = ChangesUtil.getBeforePath((Change)change);
        FilePath aPath = ChangesUtil.getAfterPath((Change)change);
        VirtualFile root = this.getRootForPath(aPath);
        if (root == null && !Comparing.equal((Object)bPath, (Object)aPath)) {
            root = this.getRootForPath(bPath);
        }
        return root;
    }

    @Nullable
    private VirtualFile getRootForPath(@Nullable FilePath file) {
        if (file == null) {
            return null;
        }
        return this.myVcsManager.getVcsRootFor(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeListManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectLevelVcsManager";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsToSave";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/impl/LocalChangesUnderRoots";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allChanges";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/impl/LocalChangesUnderRoots";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangesByLists";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "groupChanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getChangesByLists";
                break;
            }
            case 3: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getChangesUnderRoots";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "groupChanges";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getRootForChange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

