/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.persistence;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.intellij.internal.statistic.eventLog.validator.persistence.BaseEventLogWhitelistPersistence;
import com.intellij.internal.statistic.eventLog.whitelist.LocalWhitelistGroup;
import com.intellij.internal.statistic.service.fus.EventLogMetadataParseException;
import com.intellij.internal.statistic.service.fus.FUStatisticsWhiteListGroupsService;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventLogTestWhitelistPersistence
extends BaseEventLogWhitelistPersistence {
    private static final Logger LOG = Logger.getInstance(EventLogTestWhitelistPersistence.class);
    public static final String TEST_RULE = "{util#fus_test_mode}";
    private static final String DEPRECATED_TEST_EVENTS_SCHEME_FILE = "test-white-list.json";
    private static final String TEST_EVENTS_SCHEME_FILE = "test-events-scheme.json";
    @NotNull
    private final String myRecorderId;

    public EventLogTestWhitelistPersistence(@NotNull String recorderId) {
        if (recorderId == null) {
            EventLogTestWhitelistPersistence.$$$reportNull$$$0(0);
        }
        this.myRecorderId = recorderId;
    }

    @Override
    @Nullable
    public String getCachedMetadata() {
        try {
            File file = this.getWhitelistFile();
            if (file.exists()) {
                return FileUtil.loadFile((File)file);
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return null;
    }

    public void cleanup() {
        try {
            FileUtil.delete((File)this.getWhitelistFile());
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    public static FUStatisticsWhiteListGroupsService.WLGroup createGroupWithCustomRules(@NotNull String groupId, @NotNull String rules) {
        if (groupId == null) {
            EventLogTestWhitelistPersistence.$$$reportNull$$$0(1);
        }
        if (rules == null) {
            EventLogTestWhitelistPersistence.$$$reportNull$$$0(2);
        }
        String content = "{\"id\":\"" + groupId + "\",\"versions\":[ {\"from\" : \"1\"}],\"rules\":" + rules + "}";
        FUStatisticsWhiteListGroupsService.WLGroup wLGroup = (FUStatisticsWhiteListGroupsService.WLGroup)new GsonBuilder().create().fromJson(content, FUStatisticsWhiteListGroupsService.WLGroup.class);
        if (wLGroup == null) {
            EventLogTestWhitelistPersistence.$$$reportNull$$$0(3);
        }
        return wLGroup;
    }

    public static void addTestGroup(@NotNull String recorderId, @NotNull LocalWhitelistGroup group) throws IOException {
        if (recorderId == null) {
            EventLogTestWhitelistPersistence.$$$reportNull$$$0(4);
        }
        if (group == null) {
            EventLogTestWhitelistPersistence.$$$reportNull$$$0(5);
        }
        String groupId = group.getGroupId();
        FUStatisticsWhiteListGroupsService.WLGroup whitelistGroup = group.getUseCustomRules() ? EventLogTestWhitelistPersistence.createGroupWithCustomRules(groupId, group.getCustomRules()) : EventLogTestWhitelistPersistence.createTestGroup(groupId, Collections.emptySet());
        EventLogTestWhitelistPersistence.addNewGroup(recorderId, whitelistGroup);
    }

    private static void addNewGroup(@NotNull String recorderId, @NotNull FUStatisticsWhiteListGroupsService.WLGroup group) throws IOException {
        if (recorderId == null) {
            EventLogTestWhitelistPersistence.$$$reportNull$$$0(6);
        }
        if (group == null) {
            EventLogTestWhitelistPersistence.$$$reportNull$$$0(7);
        }
        EventLogTestWhitelistPersistence persistence = new EventLogTestWhitelistPersistence(recorderId);
        FUStatisticsWhiteListGroupsService.WLGroups whitelist = EventLogTestWhitelistPersistence.loadTestWhitelist(persistence);
        EventLogTestWhitelistPersistence.saveNewGroup(group, whitelist, persistence.getWhitelistFile());
    }

    public static void saveNewGroup(@NotNull FUStatisticsWhiteListGroupsService.WLGroup group, @NotNull FUStatisticsWhiteListGroupsService.WLGroups whitelist, @NotNull File file) throws IOException {
        if (group == null) {
            EventLogTestWhitelistPersistence.$$$reportNull$$$0(8);
        }
        if (whitelist == null) {
            EventLogTestWhitelistPersistence.$$$reportNull$$$0(9);
        }
        if (file == null) {
            EventLogTestWhitelistPersistence.$$$reportNull$$$0(10);
        }
        whitelist.groups.stream().filter(g -> StringUtil.equals((CharSequence)g.id, (CharSequence)group.id)).findFirst().ifPresent(whitelist.groups::remove);
        whitelist.groups.add(group);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        FileUtil.writeToFile((File)file, (String)gson.toJson((Object)whitelist));
    }

    @NotNull
    public static FUStatisticsWhiteListGroupsService.WLGroups loadTestWhitelist(@NotNull BaseEventLogWhitelistPersistence persistence) {
        String existing;
        if (persistence == null) {
            EventLogTestWhitelistPersistence.$$$reportNull$$$0(11);
        }
        if (StringUtil.isNotEmpty((String)(existing = persistence.getCachedMetadata()))) {
            FUStatisticsWhiteListGroupsService.WLGroups wLGroups;
            try {
                wLGroups = FUStatisticsWhiteListGroupsService.parseWhiteListContent((String)existing);
            }
            catch (EventLogMetadataParseException e) {
                LOG.warn("Failed parsing test whitelist", (Throwable)e);
            }
            if (wLGroups == null) {
                EventLogTestWhitelistPersistence.$$$reportNull$$$0(12);
            }
            return wLGroups;
        }
        return new FUStatisticsWhiteListGroupsService.WLGroups();
    }

    @NotNull
    public static FUStatisticsWhiteListGroupsService.WLGroup createTestGroup(@NotNull String groupId, @NotNull Set<String> eventData) {
        if (groupId == null) {
            EventLogTestWhitelistPersistence.$$$reportNull$$$0(13);
        }
        if (eventData == null) {
            EventLogTestWhitelistPersistence.$$$reportNull$$$0(14);
        }
        FUStatisticsWhiteListGroupsService.WLGroup group = new FUStatisticsWhiteListGroupsService.WLGroup();
        group.id = groupId;
        if (group.versions != null) {
            group.versions.add(new FUStatisticsWhiteListGroupsService.WLVersion("1", null));
        }
        FUStatisticsWhiteListGroupsService.WLRule rule = new FUStatisticsWhiteListGroupsService.WLRule();
        rule.event_id = ContainerUtil.newHashSet((Object[])new String[]{TEST_RULE});
        HashMap<String, HashSet> dataRules = new HashMap<String, HashSet>();
        for (String datum : eventData) {
            dataRules.put(datum, ContainerUtil.newHashSet((Object[])new String[]{TEST_RULE}));
        }
        rule.event_data = dataRules;
        group.rules = rule;
        FUStatisticsWhiteListGroupsService.WLGroup wLGroup = group;
        if (wLGroup == null) {
            EventLogTestWhitelistPersistence.$$$reportNull$$$0(15);
        }
        return wLGroup;
    }

    @NotNull
    public File getWhitelistFile() throws IOException {
        File file = EventLogTestWhitelistPersistence.getDefaultMetadataFile(this.myRecorderId, TEST_EVENTS_SCHEME_FILE, DEPRECATED_TEST_EVENTS_SCHEME_FILE);
        if (file == null) {
            EventLogTestWhitelistPersistence.$$$reportNull$$$0(16);
        }
        return file;
    }

    public void updateTestGroups(@NotNull List<LocalWhitelistGroup> groups) throws IOException {
        if (groups == null) {
            EventLogTestWhitelistPersistence.$$$reportNull$$$0(17);
        }
        FUStatisticsWhiteListGroupsService.WLGroups whitelist = new FUStatisticsWhiteListGroupsService.WLGroups();
        for (LocalWhitelistGroup group : groups) {
            String groupId = group.getGroupId();
            if (group.getUseCustomRules()) {
                whitelist.groups.add(EventLogTestWhitelistPersistence.createGroupWithCustomRules(groupId, group.getCustomRules()));
                continue;
            }
            whitelist.groups.add(EventLogTestWhitelistPersistence.createTestGroup(groupId, Collections.emptySet()));
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        FileUtil.writeToFile((File)this.getWhitelistFile(), (String)gson.toJson((Object)whitelist));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 12: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 12: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recorderId";
                break;
            }
            case 1: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rules";
                break;
            }
            case 3: 
            case 12: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/validator/persistence/EventLogTestWhitelistPersistence";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whitelist";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "persistence";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventData";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/validator/persistence/EventLogTestWhitelistPersistence";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createGroupWithCustomRules";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "loadTestWhitelist";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestGroup";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getWhitelistFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createGroupWithCustomRules";
                break;
            }
            case 3: 
            case 12: 
            case 15: 
            case 16: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addTestGroup";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addNewGroup";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "saveNewGroup";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "loadTestWhitelist";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createTestGroup";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "updateTestGroups";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 12: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

