/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.attributes;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.AttrList;
import jadx.core.dex.attributes.IAttribute;
import jadx.core.dex.attributes.annotations.Annotation;
import jadx.core.dex.attributes.annotations.AnnotationsList;
import jadx.core.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AttributeStorage {
    private final Set<AFlag> flags = EnumSet.noneOf(AFlag.class);
    private Map<AType<?>, IAttribute> attributes = Collections.emptyMap();

    public void add(AFlag flag) {
        this.flags.add(flag);
    }

    public void add(IAttribute attr) {
        this.writeAttributes().put(attr.getType(), attr);
    }

    public <T> void add(AType<AttrList<T>> type, T obj) {
        AttrList<T> list = this.get(type);
        if (list == null) {
            list = new AttrList<T>(type);
            this.add(list);
        }
        list.getList().add(obj);
    }

    public void addAll(AttributeStorage otherList) {
        this.flags.addAll(otherList.flags);
        this.writeAttributes().putAll(otherList.attributes);
    }

    public boolean contains(AFlag flag) {
        return this.flags.contains((Object)flag);
    }

    public <T extends IAttribute> boolean contains(AType<T> type) {
        return this.attributes.containsKey(type);
    }

    public <T extends IAttribute> T get(AType<T> type) {
        return (T)this.attributes.get(type);
    }

    public Annotation getAnnotation(String cls) {
        AnnotationsList aList = this.get(AType.ANNOTATION_LIST);
        return aList == null ? null : aList.get(cls);
    }

    public <T> List<T> getAll(AType<AttrList<T>> type) {
        AttrList<T> attrList = this.get(type);
        if (attrList == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(attrList.getList());
    }

    public void remove(AFlag flag) {
        this.flags.remove((Object)flag);
    }

    public <T extends IAttribute> void remove(AType<T> type) {
        if (!this.attributes.isEmpty()) {
            this.attributes.remove(type);
        }
    }

    public void remove(IAttribute attr) {
        AType<? extends IAttribute> type;
        IAttribute a;
        if (!this.attributes.isEmpty() && (a = this.attributes.get(type = attr.getType())) == attr) {
            this.attributes.remove(type);
        }
    }

    private Map<AType<?>, IAttribute> writeAttributes() {
        if (this.attributes.isEmpty()) {
            this.attributes = new IdentityHashMap(5);
        }
        return this.attributes;
    }

    public void clear() {
        this.flags.clear();
        if (!this.attributes.isEmpty()) {
            this.attributes.clear();
        }
    }

    public synchronized void unloadAttributes() {
        if (this.attributes.isEmpty()) {
            return;
        }
        Set<AType<?>> skipOnUnload = AType.SKIP_ON_UNLOAD;
        this.attributes.keySet().removeIf(attrType -> !skipOnUnload.contains(attrType));
    }

    public List<String> getAttributeStrings() {
        int size = this.flags.size() + this.attributes.size() + this.attributes.size();
        if (size == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>(size);
        for (AFlag aFlag : this.flags) {
            list.add(aFlag.toString());
        }
        for (IAttribute iAttribute : this.attributes.values()) {
            list.add(iAttribute.toString());
        }
        return list;
    }

    public boolean isEmpty() {
        return this.flags.isEmpty() && this.attributes.isEmpty();
    }

    public String toString() {
        List<String> list = this.getAttributeStrings();
        if (list.isEmpty()) {
            return "";
        }
        list.sort(String::compareTo);
        return "A[" + Utils.listToString(list) + ']';
    }
}

