function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { EuiPanel, EuiTitle, EuiSpacer, EuiAccordion } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import { FormattedMessage } from '@kbn/i18n/react';
import { ChartOptions } from './chart_options';

function SeriesPanel(_ref) {
  var seriesParams = _ref.seriesParams,
      chartProps = _objectWithoutProperties(_ref, ["seriesParams"]);

  return /*#__PURE__*/React.createElement(EuiPanel, {
    paddingSize: "s"
  }, /*#__PURE__*/React.createElement(EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/React.createElement("h3", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "visTypeVislib.controls.pointSeries.series.metricsTitle",
    defaultMessage: "Metrics"
  }))), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "s"
  }), seriesParams.map(function (chart, index) {
    return /*#__PURE__*/React.createElement(EuiAccordion, {
      id: "visEditorSeriesAccordion".concat(chart.data.id),
      key: index,
      className: "visEditorSidebar__section visEditorSidebar__collapsible",
      initialIsOpen: index === 0,
      buttonContent: chart.data.label,
      buttonContentClassName: "visEditorSidebar__aggGroupAccordionButtonContent eui-textTruncate",
      "aria-label": i18n.translate('visTypeVislib.controls.pointSeries.seriesAccordionAriaLabel', {
        defaultMessage: 'Toggle {agg} options',
        values: {
          agg: chart.data.label
        }
      })
    }, /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/React.createElement(ChartOptions, _extends({
      index: index,
      chart: chart
    }, chartProps))));
  }));
}

export { SeriesPanel };