function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useEffect, useReducer, useMemo, useCallback } from 'react';
import { EuiTitle, EuiDragDropContext, EuiDroppable, EuiDraggable, EuiSpacer, EuiPanel, EuiFormErrorText } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import { AggGroupNames, AggGroupLabels } from '../../../data/public';
import { DefaultEditorAgg } from './agg';
import { DefaultEditorAggAdd } from './agg_add';
import { isInvalidAggsTouched, isAggRemovable, calcAggIsTooLow, getEnabledMetricAggsCount } from './agg_group_helper';
import { aggGroupReducer, initAggsState, AGGS_ACTION_KEYS } from './agg_group_state';

function DefaultEditorAggGroup(_ref) {
  var formIsTouched = _ref.formIsTouched,
      groupName = _ref.groupName,
      lastParentPipelineAggTitle = _ref.lastParentPipelineAggTitle,
      metricAggs = _ref.metricAggs,
      state = _ref.state,
      _ref$schemas = _ref.schemas,
      schemas = _ref$schemas === void 0 ? [] : _ref$schemas,
      addSchema = _ref.addSchema,
      setAggParamValue = _ref.setAggParamValue,
      setStateParamValue = _ref.setStateParamValue,
      onAggTypeChange = _ref.onAggTypeChange,
      onToggleEnableAgg = _ref.onToggleEnableAgg,
      removeAgg = _ref.removeAgg,
      reorderAggs = _ref.reorderAggs,
      setTouched = _ref.setTouched,
      setValidity = _ref.setValidity,
      timeRange = _ref.timeRange;
  var groupNameLabel = AggGroupLabels[groupName]; // e.g. buckets can have no aggs

  var schemaNames = schemas.map(function (s) {
    return s.name;
  });
  var group = useMemo(function () {
    return state.data.aggs.aggs.filter(function (agg) {
      return agg.schema && schemaNames.includes(agg.schema);
    }) || [];
  }, [state.data.aggs, schemaNames]);
  var stats = {
    max: 0,
    count: group.length
  };
  schemas.forEach(function (schema) {
    stats.max += schema.max;
  });

  var _useReducer = useReducer(aggGroupReducer, group, initAggsState),
      _useReducer2 = _slicedToArray(_useReducer, 2),
      aggsState = _useReducer2[0],
      setAggsState = _useReducer2[1];

  var bucketsError = lastParentPipelineAggTitle && groupName === AggGroupNames.Buckets && !group.length ? i18n.translate('visDefaultEditor.buckets.mustHaveBucketErrorMessage', {
    defaultMessage: 'Add a bucket with "Date Histogram" or "Histogram" aggregation.',
    description: 'Date Histogram and Histogram should not be translated'
  }) : undefined;
  var isGroupValid = !bucketsError && Object.values(aggsState).every(function (item) {
    return item.valid;
  });
  var isAllAggsTouched = isInvalidAggsTouched(aggsState);
  var isMetricAggregationDisabled = useMemo(function () {
    return groupName === AggGroupNames.Metrics && getEnabledMetricAggsCount(group) === 1;
  }, [groupName, group]);
  useEffect(function () {
    // when isAllAggsTouched is true, it means that all invalid aggs are touched and we will set ngModel's touched to true
    // which indicates that Apply button can be changed to Error button (when all invalid ngModels are touched)
    setTouched(isAllAggsTouched);
  }, [isAllAggsTouched, setTouched]);
  useEffect(function () {
    // when not all invalid aggs are touched and formIsTouched becomes true, it means that Apply button was clicked.
    // and in such case we set touched state to true for all aggs
    if (formIsTouched && !isAllAggsTouched) {
      Object.keys(aggsState).map(function (_ref2) {
        var _ref3 = _slicedToArray(_ref2, 1),
            aggId = _ref3[0];

        setAggsState({
          type: AGGS_ACTION_KEYS.TOUCHED,
          payload: true,
          aggId: aggId
        });
      });
    } // adding all of the values to the deps array cause a circular re-render
    // the logic should be rewised
    // eslint-disable-next-line react-hooks/exhaustive-deps

  }, [formIsTouched]);
  useEffect(function () {
    setValidity("aggGroup__".concat(groupName), isGroupValid);
  }, [groupName, isGroupValid, setValidity]);
  var onDragEnd = useCallback(function (_ref4) {
    var source = _ref4.source,
        destination = _ref4.destination;

    if (source && destination) {
      reorderAggs(group[source.index], group[destination.index]);
    }
  }, [reorderAggs, group]);
  return /*#__PURE__*/React.createElement(EuiDragDropContext, {
    onDragEnd: onDragEnd
  }, /*#__PURE__*/React.createElement(EuiPanel, {
    "data-test-subj": "".concat(groupName, "AggGroup"),
    paddingSize: "s"
  }, /*#__PURE__*/React.createElement(EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/React.createElement("h3", null, groupNameLabel)), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "s"
  }), bucketsError && /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(EuiFormErrorText, {
    "data-test-subj": "bucketsError"
  }, bucketsError), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "s"
  })), /*#__PURE__*/React.createElement(EuiDroppable, {
    droppableId: "agg_group_dnd_".concat(groupName)
  }, /*#__PURE__*/React.createElement(React.Fragment, null, group.map(function (agg, index) {
    return /*#__PURE__*/React.createElement(EuiDraggable, {
      key: agg.id,
      index: index,
      draggableId: "agg_group_dnd_".concat(groupName, "_").concat(agg.id),
      customDragHandle: true
    }, function (provided) {
      return /*#__PURE__*/React.createElement(DefaultEditorAgg, {
        agg: agg,
        aggIndex: index,
        aggIsTooLow: calcAggIsTooLow(agg, index, group, schemas),
        dragHandleProps: provided.dragHandleProps || null,
        formIsTouched: aggsState[agg.id] ? aggsState[agg.id].touched : false,
        groupName: groupName,
        isDraggable: stats.count > 1,
        isLastBucket: groupName === AggGroupNames.Buckets && index === group.length - 1,
        isRemovable: isAggRemovable(agg, group, schemas),
        isDisabled: agg.schema === 'metric' && isMetricAggregationDisabled,
        lastParentPipelineAggTitle: lastParentPipelineAggTitle,
        metricAggs: metricAggs,
        state: state,
        setAggParamValue: setAggParamValue,
        setStateParamValue: setStateParamValue,
        onAggTypeChange: onAggTypeChange,
        onToggleEnableAgg: onToggleEnableAgg,
        removeAgg: removeAgg,
        setAggsState: setAggsState,
        schemas: schemas,
        timeRange: timeRange
      });
    });
  }))), stats.max > stats.count && /*#__PURE__*/React.createElement(DefaultEditorAggAdd, {
    group: group,
    groupName: groupName,
    schemas: schemas,
    stats: stats,
    addSchema: addSchema
  })));
}

export { DefaultEditorAggGroup };