/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { EuiBasicTable, EuiCode, EuiFlyout, EuiFlyoutBody, EuiText } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import { FormattedMessage } from '@kbn/i18n/react';
var items = [{
  input: 1234,
  urlTemplate: 'http://company.net/profiles?user_id={{value}}',
  labelTemplate: i18n.translate('indexPatternManagement.labelTemplate.example.idLabel', {
    defaultMessage: 'User #{value}',
    values: {
      value: '{{value}}'
    }
  }),
  output: '<a href="http://company.net/profiles?user_id=1234">' + i18n.translate('indexPatternManagement.labelTemplate.example.output.idLabel', {
    defaultMessage: 'User'
  }) + ' #1234</a>'
}, {
  input: '/assets/main.css',
  urlTemplate: 'http://site.com{{rawValue}}',
  labelTemplate: i18n.translate('indexPatternManagement.labelTemplate.example.pathLabel', {
    defaultMessage: 'View Asset'
  }),
  output: '<a href="http://site.com/assets/main.css">' + i18n.translate('indexPatternManagement.labelTemplate.example.output.pathLabel', {
    defaultMessage: 'View Asset'
  }) + '</a>'
}];
export var LabelTemplateFlyout = function LabelTemplateFlyout(_ref) {
  var _ref$isVisible = _ref.isVisible,
      isVisible = _ref$isVisible === void 0 ? false : _ref$isVisible,
      _ref$onClose = _ref.onClose,
      onClose = _ref$onClose === void 0 ? function () {} : _ref$onClose;
  return isVisible ? /*#__PURE__*/React.createElement(EuiFlyout, {
    onClose: onClose
  }, /*#__PURE__*/React.createElement(EuiFlyoutBody, null, /*#__PURE__*/React.createElement(EuiText, null, /*#__PURE__*/React.createElement("h3", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "indexPatternManagement.labelTemplateHeader",
    defaultMessage: "Label Template"
  })), /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "indexPatternManagement.labelTemplateLabel",
    defaultMessage: "If the URL in this field is large, it might be useful to provide an alternate template for the text version of the URL. This will be displayed instead of the url, but will still link to the URL. The format is a string which uses double curly brace notation {doubleCurlyBraces} to inject values. The following values can be accessed:",
    values: {
      doubleCurlyBraces: /*#__PURE__*/React.createElement(EuiCode, null, '{{ }}')
    }
  })), /*#__PURE__*/React.createElement("ul", null, /*#__PURE__*/React.createElement("li", null, /*#__PURE__*/React.createElement(EuiCode, null, "value"), " \u2014\xA0", /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "indexPatternManagement.labelTemplate.valueLabel",
    defaultMessage: "The fields value"
  })), /*#__PURE__*/React.createElement("li", null, /*#__PURE__*/React.createElement(EuiCode, null, "url"), " \u2014\xA0", /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "indexPatternManagement.labelTemplate.urlLabel",
    defaultMessage: "The formatted URL"
  }))), /*#__PURE__*/React.createElement("h4", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "indexPatternManagement.labelTemplate.examplesHeader",
    defaultMessage: "Examples"
  })), /*#__PURE__*/React.createElement(EuiBasicTable, {
    items: items,
    columns: [{
      field: 'input',
      name: i18n.translate('indexPatternManagement.labelTemplate.inputHeader', {
        defaultMessage: 'Input'
      }),
      width: '160px'
    }, {
      field: 'urlTemplate',
      name: i18n.translate('indexPatternManagement.labelTemplate.urlHeader', {
        defaultMessage: 'URL Template'
      })
    }, {
      field: 'labelTemplate',
      name: i18n.translate('indexPatternManagement.labelTemplate.labelHeader', {
        defaultMessage: 'Label Template'
      })
    }, {
      field: 'output',
      name: i18n.translate('indexPatternManagement.labelTemplate.outputHeader', {
        defaultMessage: 'Output'
      }),
      render: function render(value) {
        return /*#__PURE__*/React.createElement("span", {
          /*
           * Justification for dangerouslySetInnerHTML:
           * Example output produces anchor link.
           */
          dangerouslySetInnerHTML: {
            __html: value
          } // eslint-disable-line react/no-danger

        });
      }
    }]
  })))) : null;
};
LabelTemplateFlyout.displayName = 'LabelTemplateFlyout';