function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { sortBy } from 'lodash';
import { i18n } from '@kbn/i18n';
import { ResolveIndexResponseItemIndexAttrs } from '../types';
var aliasLabel = i18n.translate('indexPatternManagement.aliasLabel', {
  defaultMessage: 'Alias'
});
var dataStreamLabel = i18n.translate('indexPatternManagement.dataStreamLabel', {
  defaultMessage: 'Data stream'
});
var indexLabel = i18n.translate('indexPatternManagement.indexLabel', {
  defaultMessage: 'Index'
});
var frozenLabel = i18n.translate('indexPatternManagement.frozenLabel', {
  defaultMessage: 'Frozen'
});
export function getIndices(_x, _x2, _x3, _x4) {
  return _getIndices.apply(this, arguments);
}

function _getIndices() {
  _getIndices = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(http, indexPatternCreationType, rawPattern, showAllIndices) {
    var pattern, query, response;
    return regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            pattern = rawPattern.trim(); // Searching for `*:` fails for CCS environments. The search request
            // is worthless anyways as the we should only send a request
            // for a specific query (where we do not append *) if there is at
            // least a single character being searched for.

            if (!(pattern === '*:')) {
              _context.next = 3;
              break;
            }

            return _context.abrupt("return", []);

          case 3:
            if (!(pattern === '')) {
              _context.next = 5;
              break;
            }

            return _context.abrupt("return", []);

          case 5:
            if (!pattern.startsWith(',')) {
              _context.next = 7;
              break;
            }

            return _context.abrupt("return", []);

          case 7:
            query = showAllIndices ? {
              expand_wildcards: 'all'
            } : undefined;
            _context.prev = 8;
            _context.next = 11;
            return http.get("/internal/index-pattern-management/resolve_index/".concat(pattern), {
              query: query
            });

          case 11:
            response = _context.sent;

            if (response) {
              _context.next = 14;
              break;
            }

            return _context.abrupt("return", []);

          case 14:
            return _context.abrupt("return", responseToItemArray(response, indexPatternCreationType));

          case 17:
            _context.prev = 17;
            _context.t0 = _context["catch"](8);
            return _context.abrupt("return", []);

          case 20:
          case "end":
            return _context.stop();
        }
      }
    }, _callee, null, [[8, 17]]);
  }));
  return _getIndices.apply(this, arguments);
}

export var responseToItemArray = function responseToItemArray(response, indexPatternCreationType) {
  var source = [];
  (response.indices || []).forEach(function (index) {
    var tags = [{
      key: 'index',
      name: indexLabel,
      color: 'default'
    }];
    var isFrozen = (index.attributes || []).includes(ResolveIndexResponseItemIndexAttrs.FROZEN);
    tags.push.apply(tags, _toConsumableArray(indexPatternCreationType.getIndexTags(index.name)));

    if (isFrozen) {
      tags.push({
        name: frozenLabel,
        key: 'frozen',
        color: 'danger'
      });
    }

    source.push({
      name: index.name,
      tags: tags,
      item: index
    });
  });
  (response.aliases || []).forEach(function (alias) {
    source.push({
      name: alias.name,
      tags: [{
        key: 'alias',
        name: aliasLabel,
        color: 'default'
      }],
      item: alias
    });
  });
  (response.data_streams || []).forEach(function (dataStream) {
    source.push({
      name: dataStream.name,
      tags: [{
        key: 'data_stream',
        name: dataStreamLabel,
        color: 'primary'
      }],
      item: dataStream
    });
  });
  return sortBy(source, 'name');
};