function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { EuiEmptyPrompt, EuiLoadingSpinner, EuiText, EuiFlexGroup, EuiFlexItem, EuiTextColor } from '@elastic/eui';
export var SectionLoading = function SectionLoading(_ref) {
  var inline = _ref.inline,
      children = _ref.children,
      rest = _objectWithoutProperties(_ref, ["inline", "children"]);

  if (inline) {
    return /*#__PURE__*/React.createElement(EuiFlexGroup, {
      justifyContent: "flexStart",
      alignItems: "center",
      gutterSize: "s"
    }, /*#__PURE__*/React.createElement(EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/React.createElement(EuiLoadingSpinner, {
      size: "m"
    })), /*#__PURE__*/React.createElement(EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/React.createElement(EuiText, rest, /*#__PURE__*/React.createElement(EuiTextColor, {
      color: "subdued"
    }, children))));
  }

  return /*#__PURE__*/React.createElement(EuiEmptyPrompt, {
    title: /*#__PURE__*/React.createElement(EuiLoadingSpinner, {
      size: "xl"
    }),
    body: /*#__PURE__*/React.createElement(EuiText, {
      color: "subdued"
    }, children),
    "data-test-subj": "sectionLoading"
  });
};