/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { EmbeddablePanel } from '.';
import { EmbeddablePublicPlugin } from './plugin';
import { coreMock } from '../../../core/public/mocks';
import { dataPluginMock } from '../../data/public/mocks'; // eslint-disable-next-line

import { inspectorPluginMock } from '../../inspector/public/mocks'; // eslint-disable-next-line

import { uiActionsPluginMock } from '../../ui_actions/public/mocks';
export var createEmbeddablePanelMock = function createEmbeddablePanelMock(_ref) {
  var getActions = _ref.getActions,
      getEmbeddableFactory = _ref.getEmbeddableFactory,
      getAllEmbeddableFactories = _ref.getAllEmbeddableFactories,
      overlays = _ref.overlays,
      notifications = _ref.notifications,
      application = _ref.application,
      inspector = _ref.inspector,
      SavedObjectFinder = _ref.SavedObjectFinder;
  return function (_ref2) {
    var embeddable = _ref2.embeddable;
    return /*#__PURE__*/React.createElement(EmbeddablePanel, {
      embeddable: embeddable,
      getActions: getActions || function () {
        return Promise.resolve([]);
      },
      getAllEmbeddableFactories: getAllEmbeddableFactories || function () {
        return [];
      },
      getEmbeddableFactory: getEmbeddableFactory || function () {
        return undefined;
      },
      notifications: notifications || {},
      application: application || {},
      overlays: overlays || {},
      inspector: inspector || {},
      SavedObjectFinder: SavedObjectFinder || function () {
        return null;
      }
    });
  };
};
export var createEmbeddableStateTransferMock = function createEmbeddableStateTransferMock() {
  return {
    getIncomingEditorState: jest.fn(),
    getIncomingEmbeddablePackage: jest.fn(),
    navigateToEditor: jest.fn(),
    navigateToWithEmbeddablePackage: jest.fn()
  };
};

var createSetupContract = function createSetupContract() {
  var setupContract = {
    registerEmbeddableFactory: jest.fn(),
    setCustomEmbeddableFactoryProvider: jest.fn()
  };
  return setupContract;
};

var createStartContract = function createStartContract() {
  var startContract = {
    getEmbeddableFactories: jest.fn(),
    getEmbeddableFactory: jest.fn(),
    EmbeddablePanel: jest.fn(),
    getAttributeService: jest.fn(),
    getEmbeddablePanel: jest.fn(),
    getStateTransfer: jest.fn(function () {
      return createEmbeddableStateTransferMock();
    }),
    filtersAndTimeRangeFromContext: jest.fn(),
    filtersFromContext: jest.fn()
  };
  return startContract;
};

var createInstance = function createInstance() {
  var setupPlugins = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  var plugin = new EmbeddablePublicPlugin({});
  var setup = plugin.setup(coreMock.createSetup(), {
    uiActions: setupPlugins.uiActions || uiActionsPluginMock.createSetupContract(),
    data: dataPluginMock.createSetupContract()
  });

  var doStart = function doStart() {
    var startPlugins = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    return plugin.start(coreMock.createStart(), {
      uiActions: startPlugins.uiActions || uiActionsPluginMock.createStartContract(),
      inspector: inspectorPluginMock.createStartContract(),
      data: dataPluginMock.createStartContract()
    });
  };

  return {
    plugin: plugin,
    setup: setup,
    doStart: doStart
  };
};

export var embeddablePluginMock = {
  createSetupContract: createSetupContract,
  createStartContract: createStartContract,
  createInstance: createInstance
};