function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { i18n } from '@kbn/i18n';
import { take } from 'rxjs/operators';
import { ViewMode } from '../types';
import { EmbeddableFactoryNotFoundError } from '../errors';
export var ACTION_EDIT_PANEL = 'editPanel';
export var EditPanelAction = /*#__PURE__*/function () {
  function EditPanelAction(getEmbeddableFactory, application, stateTransfer) {
    var _this$application,
        _this = this;

    _classCallCheck(this, EditPanelAction);

    this.getEmbeddableFactory = getEmbeddableFactory;
    this.application = application;
    this.stateTransfer = stateTransfer;

    _defineProperty(this, "type", ACTION_EDIT_PANEL);

    _defineProperty(this, "id", ACTION_EDIT_PANEL);

    _defineProperty(this, "order", 50);

    _defineProperty(this, "currentAppId", void 0);

    if ((_this$application = this.application) === null || _this$application === void 0 ? void 0 : _this$application.currentAppId$) {
      this.application.currentAppId$.pipe(take(1)).subscribe(function (appId) {
        return _this.currentAppId = appId;
      });
    }
  }

  _createClass(EditPanelAction, [{
    key: "getDisplayName",
    value: function getDisplayName(_ref) {
      var embeddable = _ref.embeddable;
      var factory = this.getEmbeddableFactory(embeddable.type);

      if (!factory) {
        throw new EmbeddableFactoryNotFoundError(embeddable.type);
      }

      return i18n.translate('embeddableApi.panel.editPanel.displayName', {
        defaultMessage: 'Edit {value}',
        values: {
          value: factory.getDisplayName()
        }
      });
    }
  }, {
    key: "getIconType",
    value: function getIconType() {
      return 'pencil';
    }
  }, {
    key: "isCompatible",
    value: function () {
      var _isCompatible = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(_ref2) {
        var embeddable, canEditEmbeddable, inDashboardEditMode;
        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                embeddable = _ref2.embeddable;
                canEditEmbeddable = Boolean(embeddable && embeddable.getOutput().editable && (embeddable.getOutput().editUrl || embeddable.getOutput().editApp && embeddable.getOutput().editPath));
                inDashboardEditMode = embeddable.getInput().viewMode === ViewMode.EDIT;
                return _context.abrupt("return", Boolean(canEditEmbeddable && inDashboardEditMode));

              case 4:
              case "end":
                return _context.stop();
            }
          }
        }, _callee);
      }));

      function isCompatible(_x) {
        return _isCompatible.apply(this, arguments);
      }

      return isCompatible;
    }()
  }, {
    key: "execute",
    value: function () {
      var _execute = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2(context) {
        var appTarget, href;
        return regeneratorRuntime.wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                appTarget = this.getAppTarget(context);

                if (!appTarget) {
                  _context2.next = 10;
                  break;
                }

                if (!(this.stateTransfer && appTarget.state)) {
                  _context2.next = 7;
                  break;
                }

                _context2.next = 5;
                return this.stateTransfer.navigateToEditor(appTarget.app, {
                  path: appTarget.path,
                  state: appTarget.state
                });

              case 5:
                _context2.next = 9;
                break;

              case 7:
                _context2.next = 9;
                return this.application.navigateToApp(appTarget.app, {
                  path: appTarget.path
                });

              case 9:
                return _context2.abrupt("return");

              case 10:
                _context2.next = 12;
                return this.getHref(context);

              case 12:
                href = _context2.sent;

                if (!href) {
                  _context2.next = 16;
                  break;
                }

                window.location.href = href;
                return _context2.abrupt("return");

              case 16:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2, this);
      }));

      function execute(_x2) {
        return _execute.apply(this, arguments);
      }

      return execute;
    }()
  }, {
    key: "getAppTarget",
    value: function getAppTarget(_ref3) {
      var embeddable = _ref3.embeddable;
      var app = embeddable ? embeddable.getOutput().editApp : undefined;
      var path = embeddable ? embeddable.getOutput().editPath : undefined;

      if (app && path) {
        var state = this.currentAppId ? {
          originatingApp: this.currentAppId
        } : undefined;
        return {
          app: app,
          path: path,
          state: state
        };
      }
    }
  }, {
    key: "getHref",
    value: function () {
      var _getHref = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee3(_ref4) {
        var embeddable, editUrl;
        return regeneratorRuntime.wrap(function _callee3$(_context3) {
          while (1) {
            switch (_context3.prev = _context3.next) {
              case 0:
                embeddable = _ref4.embeddable;
                editUrl = embeddable ? embeddable.getOutput().editUrl : undefined;
                return _context3.abrupt("return", editUrl ? editUrl : '');

              case 3:
              case "end":
                return _context3.stop();
            }
          }
        }, _callee3);
      }));

      function getHref(_x3) {
        return _getHref.apply(this, arguments);
      }

      return getHref;
    }()
  }]);

  return EditPanelAction;
}();