function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { EuiFlexGroup, EuiFlexItem, EuiIcon, EuiScreenReaderOnly, EuiToolTip } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import { debounce } from 'lodash';
import { parse } from 'query-string';
import React, { useCallback, useEffect, useRef, useState } from 'react';
import { ace } from '../../../../../../../es_ui_shared/public'; // @ts-ignore

import { retrieveAutoCompleteInfo, clearSubscriptions } from '../../../../../lib/mappings/mappings';
import { ConsoleMenu } from '../../../../components';
import { useEditorReadContext, useServicesContext } from '../../../../contexts';
import { useSaveCurrentTextObject, useSendCurrentRequestToES, useSetInputEditor } from '../../../../hooks';
import * as senseEditor from '../../../../models/sense_editor';
import { autoIndent as _autoIndent, getDocumentation as _getDocumentation } from '../console_menu_actions';
import { subscribeResizeChecker } from '../subscribe_console_resize_checker';
import { applyCurrentSettings } from './apply_editor_settings';
import { registerCommands } from './keyboard_shortcuts';
var useUIAceKeyboardMode = ace.useUIAceKeyboardMode;
var abs = {
  position: 'absolute',
  top: '0',
  left: '0',
  bottom: '0',
  right: '0'
};
var DEFAULT_INPUT_VALUE = "GET _search\n{\n  \"query\": {\n    \"match_all\": {}\n  }\n}";
var inputId = 'ConAppInputTextarea';

function EditorUI(_ref) {
  var initialTextValue = _ref.initialTextValue;

  var _useServicesContext = useServicesContext(),
      _useServicesContext$s = _useServicesContext.services,
      history = _useServicesContext$s.history,
      notifications = _useServicesContext$s.notifications,
      settingsService = _useServicesContext$s.settings,
      docLinkVersion = _useServicesContext.docLinkVersion,
      elasticsearchUrl = _useServicesContext.elasticsearchUrl;

  var _useEditorReadContext = useEditorReadContext(),
      settings = _useEditorReadContext.settings;

  var setInputEditor = useSetInputEditor();
  var sendCurrentRequestToES = useSendCurrentRequestToES();
  var saveCurrentTextObject = useSaveCurrentTextObject();
  var editorRef = useRef(null);
  var editorInstanceRef = useRef(null);

  var _useState = useState(null),
      _useState2 = _slicedToArray(_useState, 2),
      textArea = _useState2[0],
      setTextArea = _useState2[1];

  useUIAceKeyboardMode(textArea);
  var openDocumentation = useCallback( /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
    var documentation;
    return regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            _context.next = 2;
            return _getDocumentation(editorInstanceRef.current, docLinkVersion);

          case 2:
            documentation = _context.sent;

            if (documentation) {
              _context.next = 5;
              break;
            }

            return _context.abrupt("return");

          case 5:
            window.open(documentation, '_blank');

          case 6:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  })), [docLinkVersion]);
  useEffect(function () {
    editorInstanceRef.current = senseEditor.create(editorRef.current);
    var editor = editorInstanceRef.current;
    var textareaElement = editorRef.current.querySelector('textarea');

    if (textareaElement) {
      textareaElement.setAttribute('id', inputId);
    }

    var readQueryParams = function readQueryParams() {
      var _split = (window.location.hash || '').split('?'),
          _split2 = _slicedToArray(_split, 2),
          queryString = _split2[1];

      return parse(queryString || '', {
        sort: false
      });
    };

    var loadBufferFromRemote = function loadBufferFromRemote(url) {
      if (/^https?:\/\//.test(url)) {
        var loadFrom = {
          url: url,
          // Having dataType here is required as it doesn't allow jQuery to `eval` content
          // coming from the external source thereby preventing XSS attack.
          dataType: 'text',
          kbnXsrfToken: false
        };

        if (/https?:\/\/api\.github\.com/.test(url)) {
          loadFrom.headers = {
            Accept: 'application/vnd.github.v3.raw'
          };
        } // Fire and forget.


        $.ajax(loadFrom).done( /*#__PURE__*/function () {
          var _ref3 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2(data) {
            var coreEditor;
            return regeneratorRuntime.wrap(function _callee2$(_context2) {
              while (1) {
                switch (_context2.prev = _context2.next) {
                  case 0:
                    coreEditor = editor.getCoreEditor();
                    _context2.next = 3;
                    return editor.update(data, true);

                  case 3:
                    editor.moveToNextRequestEdge(false);
                    coreEditor.clearSelection();
                    editor.highlightCurrentRequestsAndUpdateActionBar();
                    coreEditor.getContainer().focus();

                  case 7:
                  case "end":
                    return _context2.stop();
                }
              }
            }, _callee2);
          }));

          return function (_x) {
            return _ref3.apply(this, arguments);
          };
        }());
      }
    }; // Support for loading a console snippet from a remote source, like support docs.


    var onHashChange = debounce(function () {
      var _readQueryParams = readQueryParams(),
          url = _readQueryParams.load_from;

      if (!url) {
        return;
      }

      loadBufferFromRemote(url);
    }, 200);
    window.addEventListener('hashchange', onHashChange);
    var initialQueryParams = readQueryParams();

    if (initialQueryParams.load_from) {
      loadBufferFromRemote(initialQueryParams.load_from);
    } else {
      editor.update(initialTextValue || DEFAULT_INPUT_VALUE);
    }

    function setupAutosave() {
      var timer;
      var saveDelay = 500;
      editor.getCoreEditor().on('change', function () {
        if (timer) {
          clearTimeout(timer);
        }

        timer = window.setTimeout(saveCurrentState, saveDelay);
      });
    }

    function saveCurrentState() {
      try {
        var content = editor.getCoreEditor().getValue();
        saveCurrentTextObject(content);
      } catch (e) {// Ignoring saving error
      }
    }

    setInputEditor(editor);
    setTextArea(editorRef.current.querySelector('textarea'));
    retrieveAutoCompleteInfo(settingsService, settingsService.getAutocomplete());
    var unsubscribeResizer = subscribeResizeChecker(editorRef.current, editor);
    setupAutosave();
    return function () {
      unsubscribeResizer();
      clearSubscriptions();
      window.removeEventListener('hashchange', onHashChange);
    };
  }, [saveCurrentTextObject, initialTextValue, history, setInputEditor, settingsService]);
  useEffect(function () {
    var editor = editorInstanceRef.current;
    applyCurrentSettings(editor.getCoreEditor(), settings); // Preserve legacy focus behavior after settings have updated.

    editor.getCoreEditor().getContainer().focus();
  }, [settings]);
  useEffect(function () {
    registerCommands({
      senseEditor: editorInstanceRef.current,
      sendCurrentRequestToES: sendCurrentRequestToES,
      openDocumentation: openDocumentation
    });
  }, [sendCurrentRequestToES, openDocumentation]);
  return /*#__PURE__*/React.createElement("div", {
    style: abs,
    className: "conApp"
  }, /*#__PURE__*/React.createElement("div", {
    className: "conApp__editor"
  }, /*#__PURE__*/React.createElement("ul", {
    className: "conApp__autoComplete",
    id: "autocomplete"
  }), /*#__PURE__*/React.createElement(EuiFlexGroup, {
    className: "conApp__editorActions",
    id: "ConAppEditorActions",
    gutterSize: "none",
    responsive: false
  }, /*#__PURE__*/React.createElement(EuiFlexItem, null, /*#__PURE__*/React.createElement(EuiToolTip, {
    content: i18n.translate('console.sendRequestButtonTooltip', {
      defaultMessage: 'Click to send request'
    })
  }, /*#__PURE__*/React.createElement("button", {
    onClick: sendCurrentRequestToES,
    "data-test-subj": "sendRequestButton",
    "aria-label": i18n.translate('console.sendRequestButtonTooltip', {
      defaultMessage: 'Click to send request'
    }),
    className: "conApp__editorActionButton conApp__editorActionButton--success"
  }, /*#__PURE__*/React.createElement(EuiIcon, {
    type: "play"
  })))), /*#__PURE__*/React.createElement(EuiFlexItem, null, /*#__PURE__*/React.createElement(ConsoleMenu, {
    getCurl: function getCurl() {
      return editorInstanceRef.current.getRequestsAsCURL(elasticsearchUrl);
    },
    getDocumentation: function getDocumentation() {
      return _getDocumentation(editorInstanceRef.current, docLinkVersion);
    },
    autoIndent: function autoIndent(event) {
      _autoIndent(editorInstanceRef.current, event);
    },
    addNotification: function addNotification(_ref4) {
      var title = _ref4.title;
      return notifications.toasts.add({
        title: title
      });
    }
  }))), /*#__PURE__*/React.createElement(EuiScreenReaderOnly, null, /*#__PURE__*/React.createElement("label", {
    htmlFor: inputId
  }, i18n.translate('console.inputTextarea', {
    defaultMessage: 'Dev Tools Console'
  }))), /*#__PURE__*/React.createElement("div", {
    ref: editorRef,
    id: "ConAppEditor",
    className: "conApp__editorContent",
    "data-test-subj": "request-editor"
  })));
}

export var Editor = /*#__PURE__*/React.memo(EditorUI);