function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import angular from 'angular';
import { first } from 'rxjs/operators';
import { Subject } from 'rxjs';

/**
 * The LegacyPlatformService is responsible for initializing
 * the legacy platform by injecting parts of the new platform
 * services into the legacy platform modules, like ui/modules,
 * and then bootstrapping the ui/chrome or ui/test_harness to
 * setup either the app or browser tests.
 */
export var LegacyPlatformService = /*#__PURE__*/function () {
  /** Symbol to represent the legacy platform as a fake "plugin". Used by the ContextService */
  function LegacyPlatformService(params) {
    _classCallCheck(this, LegacyPlatformService);

    this.params = params;

    _defineProperty(this, "legacyId", Symbol());

    _defineProperty(this, "bootstrapModule", void 0);

    _defineProperty(this, "targetDomElement", void 0);

    _defineProperty(this, "startDependencies$", new Subject());

    _defineProperty(this, "startDependencies", this.startDependencies$.pipe(first()).toPromise());
  }

  _createClass(LegacyPlatformService, [{
    key: "setup",
    value: function setup(_ref) {
      var _this = this;

      var core = _ref.core,
          plugins = _ref.plugins;
      // Always register legacy apps, even if not in legacy mode.
      core.injectedMetadata.getLegacyMetadata().nav.forEach(function (navLink) {
        return core.application.registerLegacyApp({
          id: navLink.id,
          order: navLink.order,
          title: navLink.title,
          euiIconType: navLink.euiIconType,
          icon: navLink.icon,
          appUrl: navLink.url,
          subUrlBase: navLink.subUrlBase,
          linkToLastSubUrl: navLink.linkToLastSubUrl,
          category: navLink.category,
          disableSubUrlTracking: navLink.disableSubUrlTracking
        });
      });

      var legacyCore = _objectSpread(_objectSpread({}, core), {}, {
        getStartServices: function getStartServices() {
          return _this.startDependencies;
        },
        application: _objectSpread(_objectSpread({}, core.application), {}, {
          register: notSupported("core.application.register()"),
          registerMountContext: notSupported("core.application.registerMountContext()")
        })
      }); // Inject parts of the new platform into parts of the legacy platform
      // so that legacy APIs/modules can mimic their new platform counterparts


      if (core.injectedMetadata.getLegacyMode()) {
        if (!this.params.requireNewPlatformShimModule) {
          throw new Error("requireNewPlatformShimModule must be specified when rendering a legacy application");
        }

        this.params.requireNewPlatformShimModule().__setup__(legacyCore, plugins);
      }
    }
  }, {
    key: "start",
    value: function start(_ref2) {
      var core = _ref2.core,
          targetDomElement = _ref2.targetDomElement,
          plugins = _ref2.plugins,
          _ref2$lastSubUrlStora = _ref2.lastSubUrlStorage,
          lastSubUrlStorage = _ref2$lastSubUrlStora === void 0 ? window.sessionStorage : _ref2$lastSubUrlStora;
      // Initialize legacy sub urls
      core.chrome.navLinks.getAll().filter(function (link) {
        return link.legacy;
      }).forEach(function (navLink) {
        var lastSubUrl = lastSubUrlStorage.getItem("lastSubUrl:".concat(navLink.baseUrl));
        core.chrome.navLinks.update(navLink.id, {
          url: lastSubUrl || navLink.url || navLink.baseUrl
        });
      }); // Only import and bootstrap legacy platform if we're in legacy mode.

      if (!core.injectedMetadata.getLegacyMode()) {
        return;
      }

      var legacyCore = _objectSpread(_objectSpread({}, core), {}, {
        application: {
          applications$: core.application.applications$,
          currentAppId$: core.application.currentAppId$,
          capabilities: core.application.capabilities,
          getUrlForApp: core.application.getUrlForApp,
          navigateToApp: core.application.navigateToApp,
          navigateToUrl: core.application.navigateToUrl,
          registerMountContext: notSupported("core.application.registerMountContext()")
        }
      });

      this.startDependencies$.next([legacyCore, plugins, {}]);

      if (!this.params.requireNewPlatformShimModule) {
        throw new Error("requireNewPlatformShimModule must be specified when rendering a legacy application");
      }

      if (!this.params.requireLegacyBootstrapModule) {
        throw new Error("requireLegacyBootstrapModule must be specified when rendering a legacy application");
      } // Inject parts of the new platform into parts of the legacy platform
      // so that legacy APIs/modules can mimic their new platform counterparts


      this.params.requireNewPlatformShimModule().__start__(legacyCore, plugins); // Load the bootstrap module before loading the legacy platform files so that
      // the bootstrap module can modify the environment a bit first


      this.bootstrapModule = this.params.requireLegacyBootstrapModule(); // require the files that will tie into the legacy platform

      if (this.params.requireLegacyFiles) {
        this.params.requireLegacyFiles();
      }

      if (!this.bootstrapModule) {
        throw new Error('Bootstrap module must be loaded before `start`');
      } // `targetDomElement` is always defined when in legacy mode


      this.targetDomElement = targetDomElement;

      if (this.bootstrapModule.default) {
        this.bootstrapModule.default.bootstrap(this.targetDomElement);
      } else if (this.bootstrapModule.bootstrap) {
        this.bootstrapModule.bootstrap(this.targetDomElement);
      } else {
        throw new Error('legacy bootstrap module does not export a bootstrap() function');
      }
    }
  }, {
    key: "stop",
    value: function stop() {
      if (!this.targetDomElement) {
        return;
      }

      var angularRoot = angular.element(this.targetDomElement);
      var injector$ = angularRoot.injector(); // if we haven't gotten to the point of bootstrapping
      // angular, injector$ won't be defined

      if (!injector$) {
        return;
      } // destroy the root angular scope


      injector$.get('$rootScope').$destroy(); // clear the inner html of the root angular element

      this.targetDomElement.textContent = '';
    }
  }]);

  return LegacyPlatformService;
}();

var notSupported = function notSupported(methodName) {
  return function () {
    throw new Error("".concat(methodName, " is not supported in the legacy platform."));
  };
};