function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { render } from 'react-dom';
import * as Rx from 'rxjs';
import { first, tap } from 'rxjs/operators';
import { FatalErrorsScreen } from './fatal_errors_screen';
import { getErrorInfo } from './get_error_info';

/** @interal */
export var FatalErrorsService = /*#__PURE__*/function () {
  /**
   *
   * @param rootDomElement
   * @param onFirstErrorCb - Callback function that gets executed after the first error,
   *   but before the FatalErrorsService renders the error to the DOM.
   */
  function FatalErrorsService(rootDomElement, onFirstErrorCb) {
    _classCallCheck(this, FatalErrorsService);

    this.rootDomElement = rootDomElement;
    this.onFirstErrorCb = onFirstErrorCb;

    _defineProperty(this, "errorInfo$", new Rx.ReplaySubject());

    _defineProperty(this, "fatalErrors", void 0);
  }

  _createClass(FatalErrorsService, [{
    key: "setup",
    value: function setup(_ref) {
      var _this = this;

      var i18n = _ref.i18n,
          injectedMetadata = _ref.injectedMetadata;
      this.errorInfo$.pipe(first(), tap(function () {
        _this.onFirstErrorCb();

        _this.renderError(injectedMetadata, i18n);
      })).subscribe({
        error: function (_error) {
          function error(_x) {
            return _error.apply(this, arguments);
          }

          error.toString = function () {
            return _error.toString();
          };

          return error;
        }(function (error) {
          // eslint-disable-next-line no-console
          console.error('Uncaught error in fatal error service internals', error);
        })
      });
      this.fatalErrors = {
        add: function add(error, source) {
          var errorInfo = getErrorInfo(error, source);

          _this.errorInfo$.next(errorInfo);

          if (error instanceof Error) {
            // make stack traces clickable by putting whole error in the console
            // eslint-disable-next-line no-console
            console.error(error);
          }

          throw error;
        },
        get$: function get$() {
          return _this.errorInfo$.asObservable();
        }
      };
      this.setupGlobalErrorHandlers(this.fatalErrors);
      return this.fatalErrors;
    }
  }, {
    key: "start",
    value: function start() {
      var fatalErrors = this.fatalErrors;

      if (!fatalErrors) {
        throw new Error('FatalErrorsService#setup() must be invoked before start.');
      }

      return fatalErrors;
    }
  }, {
    key: "renderError",
    value: function renderError(injectedMetadata, i18n) {
      // delete all content in the rootDomElement
      this.rootDomElement.textContent = ''; // create and mount a container for the <FatalErrorScreen>

      var container = document.createElement('div');
      this.rootDomElement.appendChild(container);
      render( /*#__PURE__*/React.createElement(i18n.Context, null, /*#__PURE__*/React.createElement(FatalErrorsScreen, {
        buildNumber: injectedMetadata.getKibanaBuildNumber(),
        kibanaVersion: injectedMetadata.getKibanaVersion(),
        errorInfo$: this.errorInfo$
      })), container);
    }
  }, {
    key: "setupGlobalErrorHandlers",
    value: function setupGlobalErrorHandlers(fatalErrorsSetup) {
      if (window.addEventListener) {
        window.addEventListener('unhandledrejection', function (e) {
          console.log("Detected an unhandled Promise rejection.\n".concat(e.reason)); // eslint-disable-line no-console
        });
      }
    }
  }]);

  return FatalErrorsService;
}();