function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { act } from 'react-dom/test-utils';
import { mount } from 'enzyme';
import { I18nProvider } from '@kbn/i18n/react';
export var createRenderer = function createRenderer(element) {
  var dom = element && mount( /*#__PURE__*/React.createElement(I18nProvider, null, element));
  return function () {
    return new Promise( /*#__PURE__*/function () {
      var _ref = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2(resolve) {
        return regeneratorRuntime.wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                if (!dom) {
                  _context2.next = 3;
                  break;
                }

                _context2.next = 3;
                return act( /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
                  return regeneratorRuntime.wrap(function _callee$(_context) {
                    while (1) {
                      switch (_context.prev = _context.next) {
                        case 0:
                          dom.update();

                        case 1:
                        case "end":
                          return _context.stop();
                      }
                    }
                  }, _callee);
                })));

              case 3:
                setImmediate(function () {
                  return resolve(dom);
                }); // flushes any pending promises

              case 4:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2);
      }));

      return function (_x) {
        return _ref.apply(this, arguments);
      };
    }());
  };
};
export var createAppMounter = function createAppMounter(_ref3) {
  var appId = _ref3.appId,
      _ref3$html = _ref3.html,
      html = _ref3$html === void 0 ? "<div>App ".concat(appId, "</div>") : _ref3$html,
      _ref3$appRoute = _ref3.appRoute,
      appRoute = _ref3$appRoute === void 0 ? "/app/".concat(appId) : _ref3$appRoute,
      _ref3$exactRoute = _ref3.exactRoute,
      exactRoute = _ref3$exactRoute === void 0 ? false : _ref3$exactRoute,
      extraMountHook = _ref3.extraMountHook;
  var unmount = jest.fn();
  return [appId, {
    mounter: {
      appRoute: appRoute,
      appBasePath: appRoute,
      legacy: false,
      exactRoute: exactRoute,
      mount: jest.fn( /*#__PURE__*/function () {
        var _ref4 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee3(params) {
          var basename, element;
          return regeneratorRuntime.wrap(function _callee3$(_context3) {
            while (1) {
              switch (_context3.prev = _context3.next) {
                case 0:
                  basename = params.appBasePath, element = params.element;
                  Object.assign(element, {
                    innerHTML: "<div>\nbasename: ".concat(basename, "\nhtml: ").concat(html, "\n</div>")
                  });
                  unmount.mockImplementation(function () {
                    return Object.assign(element, {
                      innerHTML: ''
                    });
                  });

                  if (extraMountHook) {
                    extraMountHook(params);
                  }

                  return _context3.abrupt("return", unmount);

                case 5:
                case "end":
                  return _context3.stop();
              }
            }
          }, _callee3);
        }));

        return function (_x2) {
          return _ref4.apply(this, arguments);
        };
      }())
    },
    unmount: unmount
  }];
};
export var createLegacyAppMounter = function createLegacyAppMounter(appId, legacyMount) {
  return [appId, {
    mounter: {
      appRoute: "/app/".concat(appId.split(':')[0]),
      appBasePath: "/app/".concat(appId.split(':')[0]),
      unmountBeforeMounting: true,
      legacy: true,
      exactRoute: false,
      mount: legacyMount
    },
    unmount: jest.fn()
  }];
};
export function getUnmounter(app) {
  return app.mounter.mount.mock.results[0].value;
}