"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var axis_type_utils_1 = require("../../chart_types/xy_chart/utils/axis_type_utils");
var get_chart_id_1 = require("./get_chart_id");
var get_legend_size_1 = require("./get_legend_size");
var get_settings_specs_1 = require("./get_settings_specs");
var getParentDimension = function (state) { return state.parentDimensions; };
exports.getChartContainerDimensionsSelector = re_reselect_1.default([get_settings_specs_1.getSettingsSpecSelector, get_legend_size_1.getLegendSizeSelector, getParentDimension], function (settings, legendSize, parentDimensions) {
    if (!settings.showLegend) {
        return parentDimensions;
    }
    if (axis_type_utils_1.isVerticalAxis(settings.legendPosition)) {
        return {
            left: 0,
            top: 0,
            width: parentDimensions.width - legendSize.width,
            height: parentDimensions.height,
        };
    }
    return {
        left: 0,
        top: 0,
        width: parentDimensions.width,
        height: parentDimensions.height - legendSize.height,
    };
})(get_chart_id_1.getChartIdSelector);
//# sourceMappingURL=get_chart_container_dimensions.js.map