/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils.library;

import com.google.common.collect.Iterables;
import com.intellij.jarRepository.RepositoryLibraryType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryDependencyScopeSuggester;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryEditingUtil;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryDescription;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.idea.maven.utils.library.RepositoryUtils;
import org.jetbrains.idea.maven.utils.library.propertiesEditor.RepositoryLibraryPropertiesModel;

public class RepositoryLibrarySupport {
    @NotNull
    private final Project project;
    @NotNull
    private final RepositoryLibraryPropertiesModel model;
    @NotNull
    private final RepositoryLibraryDescription libraryDescription;

    public RepositoryLibrarySupport(@NotNull Project project, @NotNull RepositoryLibraryDescription libraryDescription, @NotNull RepositoryLibraryPropertiesModel model) {
        if (project == null) {
            RepositoryLibrarySupport.$$$reportNull$$$0(0);
        }
        if (libraryDescription == null) {
            RepositoryLibrarySupport.$$$reportNull$$$0(1);
        }
        if (model == null) {
            RepositoryLibrarySupport.$$$reportNull$$$0(2);
        }
        this.project = project;
        this.libraryDescription = libraryDescription;
        this.model = model;
    }

    public void addSupport(@NotNull Module module, @NotNull ModifiableRootModel rootModel, @NotNull ModifiableModelsProvider modifiableModelsProvider) {
        LibraryTable.ModifiableModel modifiableModel;
        Library library;
        if (module == null) {
            RepositoryLibrarySupport.$$$reportNull$$$0(3);
        }
        if (rootModel == null) {
            RepositoryLibrarySupport.$$$reportNull$$$0(4);
        }
        if (modifiableModelsProvider == null) {
            RepositoryLibrarySupport.$$$reportNull$$$0(5);
        }
        if ((library = (Library)Iterables.find(Arrays.asList((modifiableModel = modifiableModelsProvider.getLibraryTableModifiableModel(module.getProject())).getLibraries()), library1 -> this.isLibraryEqualsToSelected((Library)library1), null)) == null) {
            library = this.createNewLibrary(module, modifiableModel);
        } else {
            modifiableModelsProvider.disposeLibraryTableModifiableModel(modifiableModel);
        }
        DependencyScope dependencyScope = LibraryDependencyScopeSuggester.getDefaultScope(library);
        ModifiableRootModel moduleModifiableModel = modifiableModelsProvider.getModuleModifiableModel(module);
        LibraryOrderEntry foundEntry = (LibraryOrderEntry)Iterables.find(Arrays.asList(moduleModifiableModel.getOrderEntries()), entry -> entry instanceof LibraryOrderEntry && ((LibraryOrderEntry)entry).getScope() == dependencyScope && this.isLibraryEqualsToSelected(((LibraryOrderEntry)entry).getLibrary()), null);
        modifiableModelsProvider.disposeModuleModifiableModel(moduleModifiableModel);
        if (foundEntry == null) {
            rootModel.addLibraryEntry(library).setScope(dependencyScope);
        }
    }

    private LibraryEx createNewLibrary(@NotNull Module module, LibraryTable.ModifiableModel modifiableModel) {
        if (module == null) {
            RepositoryLibrarySupport.$$$reportNull$$$0(6);
        }
        RepositoryLibraryProperties libraryProperties = new RepositoryLibraryProperties(this.libraryDescription.getGroupId(), this.libraryDescription.getArtifactId(), this.model.getVersion(), this.model.isIncludeTransitiveDependencies(), this.model.getExcludedDependencies());
        LibraryEx library = (LibraryEx)modifiableModel.createLibrary(LibraryEditingUtil.suggestNewLibraryName(modifiableModel, RepositoryLibraryType.getInstance().getDescription(libraryProperties)), RepositoryLibraryType.REPOSITORY_LIBRARY_KIND);
        RepositoryLibraryProperties realLibraryProperties = (RepositoryLibraryProperties)library.getProperties();
        realLibraryProperties.setMavenId(libraryProperties.getMavenId());
        ApplicationManager.getApplication().runWriteAction(() -> modifiableModel.commit());
        RepositoryUtils.loadDependenciesToLibrary(module.getProject(), library, this.model.isDownloadSources(), this.model.isDownloadJavaDocs(), null);
        return library;
    }

    private boolean isLibraryEqualsToSelected(Library library) {
        if (!(library instanceof LibraryEx)) {
            return false;
        }
        LibraryEx libraryEx = (LibraryEx)library;
        if (!RepositoryLibraryType.REPOSITORY_LIBRARY_KIND.equals((Object)libraryEx.getKind())) {
            return false;
        }
        LibraryProperties libraryProperties = libraryEx.getProperties();
        if (!(libraryProperties instanceof RepositoryLibraryProperties)) {
            return false;
        }
        RepositoryLibraryProperties repositoryLibraryProperties = (RepositoryLibraryProperties)libraryProperties;
        RepositoryLibraryDescription description = RepositoryLibraryDescription.findDescription((RepositoryLibraryProperties)repositoryLibraryProperties);
        if (!description.equals(this.libraryDescription)) {
            return false;
        }
        return Objects.equals(repositoryLibraryProperties.getVersion(), this.model.getVersion());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryDescription";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiableModelsProvider";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/utils/library/RepositoryLibrarySupport";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addSupport";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createNewLibrary";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

