/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.opassign;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.opassign.ReplaceOperatorAssignmentWithPostfixExpressionPredicate;
import org.jetbrains.annotations.NotNull;

public class ReplaceOperatorAssignmentWithPostfixExpressionIntention
extends MutablyNamedIntention {
    @Override
    protected String getTextForElement(PsiElement element) {
        PsiAssignmentExpression assignment = (PsiAssignmentExpression)element;
        PsiJavaToken sign = assignment.getOperationSign();
        IElementType tokenType = sign.getTokenType();
        return CommonQuickFixBundle.message((String)"fix.replace.x.with.y", (Object[])new Object[]{sign.getText(), JavaTokenType.PLUSEQ.equals(tokenType) ? "++" : "--"});
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new ReplaceOperatorAssignmentWithPostfixExpressionPredicate();
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) {
        String newExpressionText;
        if (element == null) {
            ReplaceOperatorAssignmentWithPostfixExpressionIntention.$$$reportNull$$$0(0);
        }
        PsiAssignmentExpression assignment = (PsiAssignmentExpression)element;
        PsiExpression expression2 = assignment.getLExpression();
        CommentTracker commentTracker = new CommentTracker();
        String expressionText = commentTracker.text((PsiElement)expression2);
        IElementType tokenType = assignment.getOperationTokenType();
        if (JavaTokenType.PLUSEQ.equals(tokenType)) {
            newExpressionText = expressionText + "++";
        } else if (JavaTokenType.MINUSEQ.equals(tokenType)) {
            newExpressionText = expressionText + "--";
        } else {
            return;
        }
        PsiReplacementUtil.replaceExpression((PsiExpression)assignment, newExpressionText, commentTracker);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/opassign/ReplaceOperatorAssignmentWithPostfixExpressionIntention", "processIntention"));
    }
}

