/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.bool;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.bool.ConjunctionPredicate;
import org.jetbrains.annotations.NotNull;

public class DemorgansIntention
extends MutablyNamedIntention {
    @Override
    protected String getTextForElement(PsiElement element) {
        PsiPolyadicExpression binaryExpression = (PsiPolyadicExpression)element;
        IElementType tokenType = binaryExpression.getOperationTokenType();
        if (tokenType.equals(JavaTokenType.ANDAND)) {
            return CommonQuickFixBundle.message((String)"fix.replace.x.with.y", (Object[])new Object[]{"&&", "||"});
        }
        return CommonQuickFixBundle.message((String)"fix.replace.x.with.y", (Object[])new Object[]{"||", "&&"});
    }

    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        return new ConjunctionPredicate();
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        if (element == null) {
            DemorgansIntention.$$$reportNull$$$0(0);
        }
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)element;
        CommentTracker tracker = new CommentTracker();
        String newExpression = DemorgansIntention.convertConjunctionExpression(polyadicExpression, tracker);
        DemorgansIntention.replaceExpressionWithNegatedExpressionString(newExpression, (PsiExpression)polyadicExpression, tracker);
    }

    private static String convertConjunctionExpression(PsiPolyadicExpression polyadicExpression, CommentTracker tracker) {
        IElementType tokenType = polyadicExpression.getOperationTokenType();
        boolean tokenTypeAndAnd = tokenType.equals(JavaTokenType.ANDAND);
        String flippedToken = tokenTypeAndAnd ? "||" : "&&";
        StringBuilder result = new StringBuilder();
        for (PsiElement child : polyadicExpression.getChildren()) {
            if (child instanceof PsiJavaToken) {
                result.append(flippedToken);
                continue;
            }
            if (child instanceof PsiExpression) {
                result.append(DemorgansIntention.convertLeafExpression((PsiExpression)child, tokenTypeAndAnd, tracker));
                continue;
            }
            result.append(tracker.text(child));
        }
        return result.toString();
    }

    private static String convertLeafExpression(PsiExpression expression2, boolean tokenTypeAndAnd, CommentTracker tracker) {
        if (BoolUtils.isNegation(expression2)) {
            PsiExpression negatedExpression = BoolUtils.getNegated(expression2);
            if (negatedExpression == null) {
                return "";
            }
            if (negatedExpression instanceof PsiLiteralExpression) {
                return DemorgansIntention.safeText(negatedExpression);
            }
            return tracker.text(negatedExpression, tokenTypeAndAnd ? 14 : 13);
        }
        if (ComparisonUtils.isComparison(expression2)) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression2;
            String negatedComparison = ComparisonUtils.getNegatedComparison(binaryExpression.getOperationTokenType());
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            if (rhs != null) {
                String lhsText = lhs instanceof PsiLiteralExpression ? DemorgansIntention.safeText(lhs) : tracker.text((PsiElement)lhs);
                String rhsText = rhs instanceof PsiLiteralExpression ? DemorgansIntention.safeText(rhs) : tracker.text((PsiElement)rhs);
                return lhsText + negatedComparison + rhsText;
            }
        }
        if (expression2 instanceof PsiLiteralExpression) {
            return '!' + DemorgansIntention.safeText(expression2);
        }
        return '!' + tracker.text(expression2, 3);
    }

    private static String safeText(PsiExpression expression2) {
        if (!(expression2 instanceof PsiLiteralExpression)) {
            throw new IllegalArgumentException();
        }
        String text2 = expression2.getText();
        int length = text2.length();
        if (text2.charAt(0) == '\"' && (length == 1 || !text2.endsWith("\"") || DemorgansIntention.endsWithEscapedQuote(text2))) {
            return text2 + '\"';
        }
        return text2;
    }

    private static boolean endsWithEscapedQuote(String text2) {
        int length = text2.length();
        if (text2.charAt(length - 1) == '\"') {
            boolean escaped = false;
            for (int i = length - 2; i > 0 && text2.charAt(i) == '\\'; --i) {
                escaped = !escaped;
            }
            return escaped;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/bool/DemorgansIntention", "processIntention"));
    }
}

