/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessaryToStringCallInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.tostring.call.problem.descriptor", new Object[0]);
        if (string == null) {
            UnnecessaryToStringCallInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        String text2 = (String)infos[0];
        return new UnnecessaryToStringCallFix(text2);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryToStringCallVisitor();
    }

    @Contract(value="null -> false")
    private static boolean isRedundantToString(PsiMethodCallExpression call) {
        if (call == null) {
            return false;
        }
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        String referenceName = methodExpression.getReferenceName();
        if (!"toString".equals(referenceName) || !call.getArgumentList().isEmpty()) {
            return false;
        }
        PsiExpression qualifier = ExpressionUtils.getEffectiveQualifier(methodExpression);
        if (qualifier == null || qualifier.getType() instanceof PsiArrayType) {
            return false;
        }
        if (qualifier instanceof PsiSuperExpression) {
            return false;
        }
        boolean throwable = TypeUtils.expressionHasTypeOrSubtype(qualifier, "java.lang.Throwable");
        return !ExpressionUtils.isConversionToStringNecessary((PsiExpression)call, throwable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessaryToStringCallInspection", "buildErrorString"));
    }

    private static class UnnecessaryToStringCallVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryToStringCallVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression call) {
            if (!UnnecessaryToStringCallInspection.isRedundantToString(call)) {
                return;
            }
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            PsiElement referenceNameElement2 = methodExpression.getReferenceNameElement();
            if (referenceNameElement2 == null) {
                return;
            }
            PsiExpression qualifier = ExpressionUtils.getEffectiveQualifier(methodExpression);
            if (qualifier == null) {
                return;
            }
            this.registerError(referenceNameElement2, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[]{qualifier.isPhysical() ? null : qualifier.getText()});
        }
    }

    private static class UnnecessaryToStringCallFix
    extends InspectionGadgetsFix {
        @Nullable
        private final String replacementText;

        private UnnecessaryToStringCallFix(@Nullable String replacementText) {
            this.replacementText = replacementText;
        }

        @NotNull
        public String getName() {
            if (this.replacementText == null) {
                String string = InspectionGadgetsBundle.message("inspection.redundant.string.remove.fix.name", "toString");
                if (string == null) {
                    UnnecessaryToStringCallFix.$$$reportNull$$$0(0);
                }
                return string;
            }
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.replacementText});
            if (string == null) {
                UnnecessaryToStringCallFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.simplify", (Object[])new Object[0]);
            if (string == null) {
                UnnecessaryToStringCallFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)descriptor.getPsiElement().getParent().getParent(), PsiMethodCallExpression.class);
            if (!UnnecessaryToStringCallInspection.isRedundantToString(call)) {
                return;
            }
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            PsiExpression qualifier = ExpressionUtils.getEffectiveQualifier(methodExpression);
            if (qualifier == null) {
                return;
            }
            new CommentTracker().replaceAndRestoreComments((PsiElement)call, (PsiElement)qualifier);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/style/UnnecessaryToStringCallInspection$UnnecessaryToStringCallFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

