/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessaryCallToStringValueOfInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    private static final CallMatcher STATIC_TO_STRING_CONVERTERS = CallMatcher.anyOf(CallMatcher.staticCall("java.lang.String", "valueOf").parameterTypes("boolean"), CallMatcher.staticCall("java.lang.String", "valueOf").parameterTypes("char"), CallMatcher.staticCall("java.lang.String", "valueOf").parameterTypes("double"), CallMatcher.staticCall("java.lang.String", "valueOf").parameterTypes("float"), CallMatcher.staticCall("java.lang.String", "valueOf").parameterTypes("int"), CallMatcher.staticCall("java.lang.String", "valueOf").parameterTypes("long"), CallMatcher.staticCall("java.lang.String", "valueOf").parameterTypes("java.lang.Object"), CallMatcher.staticCall("java.lang.Boolean", "toString").parameterTypes("boolean"), CallMatcher.staticCall("java.lang.Byte", "toString").parameterTypes("byte"), CallMatcher.staticCall("java.lang.Short", "toString").parameterTypes("short"), CallMatcher.staticCall("java.lang.Character", "toString").parameterTypes("char"), CallMatcher.staticCall("java.lang.Integer", "toString").parameterTypes("int"), CallMatcher.staticCall("java.lang.Long", "toString").parameterTypes("long"), CallMatcher.staticCall("java.lang.Float", "toString").parameterTypes("float"), CallMatcher.staticCall("java.lang.Double", "toString").parameterTypes("double"), CallMatcher.staticCall("java.util.Objects", "toString").parameterTypes("java.lang.Object"));

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.tostring.call.problem.descriptor", new Object[0]);
        if (string == null) {
            UnnecessaryCallToStringValueOfInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        String text2 = (String)infos[0];
        return new UnnecessaryCallToStringValueOfFix(text2);
    }

    public static String calculateReplacementText(PsiExpression expression2) {
        if (!(expression2 instanceof PsiPolyadicExpression)) {
            return expression2.getText();
        }
        PsiType type2 = expression2.getType();
        if (TypeUtils.typeEquals("java.lang.String", type2) || ParenthesesUtils.getPrecedence(expression2) < 6) {
            return expression2.getText();
        }
        return '(' + expression2.getText() + ')';
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryCallToStringValueOfVisitor();
    }

    @Nullable
    private static PsiExpression tryUnwrapRedundantConversion(PsiMethodCallExpression call) {
        boolean throwable;
        if (!STATIC_TO_STRING_CONVERTERS.test(call)) {
            return null;
        }
        PsiExpression argument = PsiUtil.skipParenthesizedExprDown((PsiExpression)call.getArgumentList().getExpressions()[0]);
        if (argument == null) {
            return null;
        }
        PsiType argumentType = argument.getType();
        if (argumentType instanceof PsiPrimitiveType) {
            PsiMethod method = call.resolveMethod();
            assert (method != null);
            if (!Objects.requireNonNull(method.getParameterList().getParameter(0)).getType().equals(argumentType)) {
                return null;
            }
        }
        if (ExpressionUtils.isConversionToStringNecessary((PsiExpression)call, throwable = TypeUtils.expressionHasTypeOrSubtype(argument, "java.lang.Throwable")) && (!TypeUtils.isJavaLangString(argumentType) || NullabilityUtil.getExpressionNullability(argument, true) != Nullability.NOT_NULL)) {
            return null;
        }
        if (UnnecessaryCallToStringValueOfInspection.isReplacementAmbiguous(call, argument)) {
            return null;
        }
        return argument;
    }

    private static boolean isReplacementAmbiguous(PsiMethodCallExpression call, PsiExpression argument) {
        if (!PsiPolyExpressionUtil.isPolyExpression((PsiExpression)argument)) {
            return false;
        }
        PsiExpressionList exprList = (PsiExpressionList)ObjectUtils.tryCast((Object)ParenthesesUtils.getParentSkipParentheses((PsiElement)call), PsiExpressionList.class);
        if (exprList == null) {
            return false;
        }
        PsiCallExpression parentCall = (PsiCallExpression)ObjectUtils.tryCast((Object)exprList.getParent(), PsiCallExpression.class);
        if (parentCall == null) {
            return false;
        }
        PsiCallExpression copy = (PsiCallExpression)parentCall.copy();
        int argIndex = ContainerUtil.indexOf(Arrays.asList(exprList.getExpressions()), expr2 -> PsiUtil.skipParenthesizedExprDown((PsiExpression)expr2) == call);
        assert (argIndex >= -1);
        PsiExpression argCopy = Objects.requireNonNull(copy.getArgumentList()).getExpressions()[argIndex];
        argCopy.replace((PsiElement)argument);
        JavaResolveResult result = copy.resolveMethodGenerics();
        return !result.isValidResult();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessaryCallToStringValueOfInspection", "buildErrorString"));
    }

    private static class UnnecessaryCallToStringValueOfVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryCallToStringValueOfVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression call) {
            PsiExpression argument = UnnecessaryCallToStringValueOfInspection.tryUnwrapRedundantConversion(call);
            if (argument == null) {
                return;
            }
            this.registerErrorAtOffset((PsiElement)call, 0, call.getArgumentList().getStartOffsetInParent(), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[]{UnnecessaryCallToStringValueOfInspection.calculateReplacementText(argument)});
        }
    }

    private static class UnnecessaryCallToStringValueOfFix
    extends InspectionGadgetsFix {
        private final String replacementText;

        UnnecessaryCallToStringValueOfFix(String replacementText) {
            this.replacementText = replacementText;
        }

        @NotNull
        public String getName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.replacementText});
            if (string == null) {
                UnnecessaryCallToStringValueOfFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.simplify", (Object[])new Object[0]);
            if (string == null) {
                UnnecessaryCallToStringValueOfFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)descriptor.getPsiElement(), PsiMethodCallExpression.class);
            if (call == null) {
                return;
            }
            PsiExpression arg = UnnecessaryCallToStringValueOfInspection.tryUnwrapRedundantConversion(call);
            if (arg == null) {
                return;
            }
            CommentTracker tracker = new CommentTracker();
            PsiReplacementUtil.replaceExpression((PsiExpression)call, UnnecessaryCallToStringValueOfInspection.calculateReplacementText(tracker.markUnchanged(arg)), tracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/style/UnnecessaryCallToStringValueOfInspection$UnnecessaryCallToStringValueOfFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

