/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.security;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.FileTypeUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.MakeMethodFinalFix;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DesignForExtensionInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("design.for.extension.problem.descriptor", new Object[0]);
        if (string == null) {
            DesignForExtensionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiMethod method = (PsiMethod)infos[0];
        if (MethodUtils.isOverridden(method)) {
            return null;
        }
        return new MakeMethodFinalFix(method.getName());
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return !FileTypeUtils.isInServerPageFile((PsiElement)file);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new DesignForExtensionVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/security/DesignForExtensionInspection", "buildErrorString"));
    }

    private static class DesignForExtensionVisitor
    extends BaseInspectionVisitor {
        private DesignForExtensionVisitor() {
        }

        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            if (method.isConstructor()) {
                return;
            }
            if (method.hasModifierProperty("private") || method.hasModifierProperty("final") || method.hasModifierProperty("abstract") || method.hasModifierProperty("static")) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (containingClass.isEnum() || containingClass.isInterface() || containingClass.isAnnotationType()) {
                return;
            }
            if (containingClass.hasModifierProperty("final")) {
                return;
            }
            if (containingClass instanceof PsiAnonymousClass) {
                return;
            }
            PsiCodeBlock body2 = method.getBody();
            if (ControlFlowUtils.isEmptyCodeBlock(body2)) {
                return;
            }
            this.registerMethodError(method, method);
        }
    }
}

