/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.macro.SuggestVariableNameMacro;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightUtils {
    private HighlightUtils() {
    }

    public static void highlightElement(@NotNull PsiElement element) {
        if (element == null) {
            HighlightUtils.$$$reportNull$$$0(0);
        }
        HighlightUtils.highlightElements(Collections.singleton(element));
    }

    public static void highlightElement(@NotNull PsiElement element, Editor editor) {
        if (element == null) {
            HighlightUtils.$$$reportNull$$$0(1);
        }
        HighlightUtils.highlightElements(Collections.singleton(element), editor);
    }

    public static void highlightElements(@NotNull Collection<? extends PsiElement> elementCollection, Editor editor) {
        if (elementCollection == null) {
            HighlightUtils.$$$reportNull$$$0(2);
        }
        HighlightUtils.highlightElements(elementCollection, InspectionGadgetsBundle.message("press.escape.to.remove.highlighting.message", new Object[0]), editor);
    }

    public static void highlightElement(@NotNull PsiElement element, String statusBarText) {
        if (element == null) {
            HighlightUtils.$$$reportNull$$$0(3);
        }
        HighlightUtils.highlightElements(Collections.singleton(element), statusBarText);
    }

    public static void highlightElements(@NotNull Collection<? extends PsiElement> elementCollection) {
        if (elementCollection == null) {
            HighlightUtils.$$$reportNull$$$0(4);
        }
        HighlightUtils.highlightElements(elementCollection, InspectionGadgetsBundle.message("press.escape.to.remove.highlighting.message", new Object[0]));
    }

    @Deprecated
    public static void highlightElements(@NotNull Collection<? extends PsiElement> elementCollection, String statusBarText) {
        if (elementCollection == null) {
            HighlightUtils.$$$reportNull$$$0(5);
        }
        if (elementCollection.isEmpty()) {
            return;
        }
        Editor selectedTextEditor = FileEditorManager.getInstance((Project)((PsiElement)ContainerUtil.getFirstItem(elementCollection)).getProject()).getSelectedTextEditor();
        HighlightUtils.highlightElements(elementCollection, statusBarText, selectedTextEditor);
    }

    public static void highlightElements(@NotNull Collection<? extends PsiElement> elementCollection, String statusBarText, @Nullable Editor editor) {
        if (elementCollection == null) {
            HighlightUtils.$$$reportNull$$$0(6);
        }
        if (elementCollection.isEmpty()) {
            return;
        }
        if (!HighlightUtils.checkEditor(editor)) {
            return;
        }
        if (elementCollection.contains(null)) {
            throw new IllegalArgumentException("Nulls passed in collection: " + elementCollection);
        }
        Application application = ApplicationManager.getApplication();
        application.invokeLater(() -> {
            Object[] elements = PsiUtilCore.toPsiElementArray((Collection)elementCollection);
            if (ContainerUtil.exists((Object[])elements, element -> !element.isValid())) {
                return;
            }
            Object firstElement = elements[0];
            Project project = firstElement.getProject();
            if (project.isDisposed() || editor.isDisposed()) {
                return;
            }
            HighlightManager.getInstance((Project)project).addOccurrenceHighlights(editor, (PsiElement[])elements, EditorColors.SEARCH_RESULT_ATTRIBUTES, true, null);
            WindowManager.getInstance().getStatusBar(project).setInfo(statusBarText);
            FindManager findmanager = FindManager.getInstance((Project)project);
            FindModel findmodel = findmanager.getFindNextModel();
            if (findmodel == null) {
                findmodel = findmanager.getFindInFileModel();
            }
            findmodel.setSearchHighlighters(true);
            findmanager.setFindWasPerformed();
            findmanager.setFindNextModel(findmodel);
        });
    }

    private static boolean checkEditor(@Nullable Editor editor) {
        return editor != null && !editor.isViewer();
    }

    public static void showRenameTemplate(PsiElement context, PsiNameIdentifierOwner element, PsiReference ... references) {
        if (!element.isPhysical()) {
            return;
        }
        Project project = (context = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)context)).getProject();
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        Editor editor = fileEditorManager.getSelectedTextEditor();
        if (editor == null) {
            return;
        }
        TemplateBuilderImpl builder = new TemplateBuilderImpl(context);
        MacroCallNode macroCallNode = new MacroCallNode((Macro)new SuggestVariableNameMacro());
        PsiElement identifier = element.getNameIdentifier();
        builder.replaceElement(identifier, "PATTERN", (Expression)macroCallNode, true);
        for (PsiReference reference : references) {
            builder.replaceElement(reference, "PATTERN", "PATTERN", false);
        }
        Template template = builder.buildInlineTemplate();
        TextRange textRange = context.getTextRange();
        int startOffset = textRange.getStartOffset();
        editor.getCaretModel().moveToOffset(startOffset);
        TemplateManager templateManager = TemplateManager.getInstance((Project)project);
        templateManager.startTemplate(editor, template);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementCollection";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/psiutils/HighlightUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightElement";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightElements";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

