/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;

abstract class CollectionReplaceableByEnumCollectionVisitor
extends BaseInspectionVisitor {
    CollectionReplaceableByEnumCollectionVisitor() {
    }

    public final void visitNewExpression(@NotNull PsiNewExpression expression2) {
        PsiExpression[] arguments;
        PsiMember member;
        PsiType[] typeArguments;
        if (expression2 == null) {
            CollectionReplaceableByEnumCollectionVisitor.$$$reportNull$$$0(0);
        }
        super.visitNewExpression(expression2);
        PsiType type2 = expression2.getType();
        if (!(type2 instanceof PsiClassType)) {
            return;
        }
        PsiClassType classType = (PsiClassType)type2;
        PsiType expectedType = ExpectedTypeUtils.findExpectedType((PsiExpression)expression2, false);
        if (!(expectedType instanceof PsiClassType)) {
            return;
        }
        if (!classType.hasParameters()) {
            classType = (PsiClassType)expectedType;
        }
        if ((typeArguments = classType.getParameters()).length == 0) {
            return;
        }
        PsiType argumentType = typeArguments[0];
        if (!(argumentType instanceof PsiClassType)) {
            return;
        }
        if (!TypeUtils.expressionHasTypeOrSubtype((PsiExpression)expression2, this.getBaseCollectionName())) {
            return;
        }
        if (TypeUtils.expressionHasTypeOrSubtype((PsiExpression)expression2, this.getReplacementCollectionName()) || TypeUtils.expressionHasTypeOrSubtype((PsiExpression)expression2, this.getUnreplaceableCollectionNames())) {
            return;
        }
        PsiClassType argumentClassType = (PsiClassType)argumentType;
        PsiClass argumentClass = argumentClassType.resolve();
        if (argumentClass == null || !argumentClass.isEnum()) {
            return;
        }
        PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiClass.class);
        if (argumentClass.equals(aClass) && (member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiMember.class)) != null && !member.hasModifierProperty("static")) {
            return;
        }
        PsiExpressionList argumentList = expression2.getArgumentList();
        if (argumentList != null && (arguments = argumentList.getExpressions()).length > 0 && TypeUtils.expressionHasTypeOrSubtype(arguments[0], "java.util.Comparator")) {
            return;
        }
        PsiClassType replacementCollectionType = TypeUtils.getType(this.getReplacementCollectionName(), (PsiElement)expression2);
        if (!expectedType.isAssignableFrom((PsiType)replacementCollectionType) && !this.isReplaceableType((PsiClassType)expectedType)) {
            return;
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2.getParent());
        PsiLocalVariable localVariable = (PsiLocalVariable)ObjectUtils.tryCast((Object)parent, PsiLocalVariable.class);
        if (localVariable != null) {
            PsiClass localVariableClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)localVariable.getType());
            if (localVariableClass != null && this.getBaseCollectionName().equals(localVariableClass.getQualifiedName())) {
                this.registerNewExpressionError(expression2, localVariable);
            } else {
                this.registerNewExpressionError(expression2, new Object[0]);
            }
        } else {
            this.registerNewExpressionError(expression2, new Object[0]);
        }
    }

    private boolean isReplaceableType(PsiClassType classType) {
        PsiClassType rawType = classType.rawType();
        return this.getReplaceableCollectionNames().stream().anyMatch(s -> rawType.equalsToText(s));
    }

    @NotNull
    protected abstract List<String> getUnreplaceableCollectionNames();

    @NotNull
    protected abstract List<String> getReplaceableCollectionNames();

    @NotNull
    protected abstract String getReplacementCollectionName();

    @NotNull
    protected abstract String getBaseCollectionName();

    static PsiType[] extractParameterType(@NotNull PsiLocalVariable localVariable, int expectedParameterCount) {
        PsiExpression initializer;
        PsiNewExpression newExpression;
        if (localVariable == null) {
            CollectionReplaceableByEnumCollectionVisitor.$$$reportNull$$$0(1);
        }
        if ((newExpression = (PsiNewExpression)ObjectUtils.tryCast((Object)(initializer = PsiUtil.skipParenthesizedExprDown((PsiExpression)localVariable.getInitializer())), PsiNewExpression.class)) == null) {
            return null;
        }
        PsiExpressionList argumentList = newExpression.getArgumentList();
        if (argumentList == null || !argumentList.isEmpty()) {
            return null;
        }
        PsiJavaCodeReferenceElement classReference2 = newExpression.getClassReference();
        if (classReference2 == null) {
            return null;
        }
        PsiReferenceParameterList parameterList = classReference2.getParameterList();
        if (parameterList == null) {
            return null;
        }
        PsiClassType classType = (PsiClassType)ObjectUtils.tryCast((Object)newExpression.getType(), PsiClassType.class);
        if (classType == null) {
            return null;
        }
        if (classType.getParameterCount() != expectedParameterCount) {
            return null;
        }
        return classType.getParameters();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localVariable";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/performance/CollectionReplaceableByEnumCollectionVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitNewExpression";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "extractParameterType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

