/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.packaging;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseGlobalInspection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmptyDirectoryInspection
extends BaseGlobalInspection {
    public boolean onlyReportDirectoriesUnderSourceRoots = false;

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("empty.directories.only.under.source.roots.option", new Object[0]), (InspectionProfileEntry)this, "onlyReportDirectoriesUnderSourceRoots");
    }

    public boolean isGraphNeeded() {
        return false;
    }

    public void runInspection(@NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext context, @NotNull ProblemDescriptionsProcessor processor2) {
        if (scope == null) {
            EmptyDirectoryInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            EmptyDirectoryInspection.$$$reportNull$$$0(1);
        }
        if (context == null) {
            EmptyDirectoryInspection.$$$reportNull$$$0(2);
        }
        if (processor2 == null) {
            EmptyDirectoryInspection.$$$reportNull$$$0(3);
        }
        Project project = context.getProject();
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        SearchScope searchScope = (SearchScope)ReadAction.compute(() -> scope.toSearchScope());
        if (!(searchScope instanceof GlobalSearchScope)) {
            return;
        }
        GlobalSearchScope globalSearchScope = (GlobalSearchScope)searchScope;
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        ((Map)ReadAction.nonBlocking(() -> {
            HashMap results = new HashMap();
            index.iterateContent(fileOrDir -> {
                if (this.onlyReportDirectoriesUnderSourceRoots && !index.isInSourceContent(fileOrDir)) {
                    return true;
                }
                VirtualFile[] children = fileOrDir.getChildren();
                if (children.length != 0) {
                    return true;
                }
                PsiDirectory directory = psiManager.findDirectory(fileOrDir);
                RefElement refDirectory = context.getRefManager().getReference((PsiElement)directory);
                if (refDirectory == null || context.shouldCheck((RefEntity)refDirectory, (GlobalInspectionTool)this)) {
                    return true;
                }
                String relativePath = EmptyDirectoryInspection.getPathRelativeToModule(fileOrDir, project);
                if (relativePath == null) {
                    return true;
                }
                results.put(refDirectory, manager.createProblemDescriptor(InspectionGadgetsBundle.message("empty.directories.problem.descriptor", relativePath), new QuickFix[]{new EmptyPackageFix(fileOrDir.getUrl(), fileOrDir.getName())}));
                return true;
            }, (VirtualFileFilter)globalSearchScope);
            return results;
        }).executeSynchronously()).forEach((element, descriptor) -> processor2.addProblemElement((RefEntity)element, new CommonProblemDescriptor[]{descriptor}));
    }

    @Nullable
    private static String getPathRelativeToModule(VirtualFile file, Project project) {
        VirtualFile[] contentRoots;
        ProjectRootManager rootManager = ProjectRootManager.getInstance((Project)project);
        for (VirtualFile otherRoot : contentRoots = rootManager.getContentRootsFromAllModules()) {
            if (!VfsUtilCore.isAncestor((VirtualFile)otherRoot, (VirtualFile)file, (boolean)false)) continue;
            return VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)otherRoot, (char)'/');
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "scope";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "processor";
                break;
            }
        }
        objectArray[1] = "com/siyeh/ig/packaging/EmptyDirectoryInspection";
        objectArray[2] = "runInspection";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class EmptyPackageFix
    implements QuickFix {
        private final String url;
        private final String name;

        EmptyPackageFix(String url, String name2) {
            this.url = url;
            this.name = name2;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("empty.directories.delete.quickfix", this.name);
            if (string == null) {
                EmptyPackageFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("empty.directories.delete.quickfix", "");
            if (string == null) {
                EmptyPackageFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull CommonProblemDescriptor descriptor) {
            VirtualFile file;
            if (project == null) {
                EmptyPackageFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                EmptyPackageFix.$$$reportNull$$$0(3);
            }
            if ((file = VirtualFileManager.getInstance().findFileByUrl(this.url)) == null) {
                return;
            }
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            PsiDirectory directory = psiManager.findDirectory(file);
            if (directory == null) {
                return;
            }
            directory.delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/packaging/EmptyDirectoryInspection$EmptyPackageFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/packaging/EmptyDirectoryInspection$EmptyPackageFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

