/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleIntegerFieldOptionsPanel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.ExtractMethodFix;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class OverlyComplexArithmeticExpressionInspection
extends BaseInspection {
    protected static final Set<IElementType> arithmeticTokens = new HashSet<IElementType>(5);
    private static final int TERM_LIMIT = 6;
    public int m_limit = 6;

    public JComponent createOptionsPanel() {
        return new SingleIntegerFieldOptionsPanel(InspectionGadgetsBundle.message("overly.complex.arithmetic.expression.max.number.option", new Object[0]), (InspectionProfileEntry)this, "m_limit");
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ExtractMethodFix();
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("overly.complex.arithmetic.expression.problem.descriptor", new Object[0]);
        if (string == null) {
            OverlyComplexArithmeticExpressionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new OverlyComplexArithmeticExpressionVisitor();
    }

    static {
        arithmeticTokens.add(JavaTokenType.PLUS);
        arithmeticTokens.add(JavaTokenType.MINUS);
        arithmeticTokens.add(JavaTokenType.ASTERISK);
        arithmeticTokens.add(JavaTokenType.DIV);
        arithmeticTokens.add(JavaTokenType.PERC);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/OverlyComplexArithmeticExpressionInspection", "buildErrorString"));
    }

    private class OverlyComplexArithmeticExpressionVisitor
    extends BaseInspectionVisitor {
        private OverlyComplexArithmeticExpressionVisitor() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression2) {
            if (expression2 == null) {
                OverlyComplexArithmeticExpressionVisitor.$$$reportNull$$$0(0);
            }
            super.visitBinaryExpression(expression2);
            this.checkExpression((PsiExpression)expression2);
        }

        public void visitPrefixExpression(@NotNull PsiPrefixExpression expression2) {
            if (expression2 == null) {
                OverlyComplexArithmeticExpressionVisitor.$$$reportNull$$$0(1);
            }
            super.visitPrefixExpression(expression2);
            this.checkExpression((PsiExpression)expression2);
        }

        public void visitParenthesizedExpression(PsiParenthesizedExpression expression2) {
            super.visitParenthesizedExpression(expression2);
            this.checkExpression((PsiExpression)expression2);
        }

        private void checkExpression(PsiExpression expression2) {
            if (this.isParentArithmetic(expression2)) {
                return;
            }
            if (!this.isArithmetic(expression2)) {
                return;
            }
            int numTerms = this.countTerms(expression2);
            if (numTerms <= OverlyComplexArithmeticExpressionInspection.this.m_limit) {
                return;
            }
            this.registerError((PsiElement)expression2, new Object[0]);
        }

        private int countTerms(PsiExpression expression2) {
            if (!this.isArithmetic(expression2)) {
                return 1;
            }
            if (expression2 instanceof PsiBinaryExpression) {
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression2;
                PsiExpression lhs = binaryExpression.getLOperand();
                PsiExpression rhs = binaryExpression.getROperand();
                return this.countTerms(lhs) + this.countTerms(rhs);
            }
            if (expression2 instanceof PsiPrefixExpression) {
                PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression2;
                PsiExpression operand2 = prefixExpression.getOperand();
                return this.countTerms(operand2);
            }
            if (expression2 instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression2;
                PsiExpression contents = parenthesizedExpression.getExpression();
                return this.countTerms(contents);
            }
            return 1;
        }

        private boolean isParentArithmetic(PsiExpression expression2) {
            PsiElement parent = expression2.getParent();
            return parent instanceof PsiExpression && this.isArithmetic((PsiExpression)parent);
        }

        private boolean isArithmetic(PsiExpression expression2) {
            if (expression2 instanceof PsiBinaryExpression) {
                PsiType type2 = expression2.getType();
                if (TypeUtils.isJavaLangString(type2)) {
                    return false;
                }
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression2;
                return arithmeticTokens.contains(binaryExpression.getOperationTokenType());
            }
            if (expression2 instanceof PsiPrefixExpression) {
                PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression2;
                return arithmeticTokens.contains(prefixExpression.getOperationTokenType());
            }
            if (expression2 instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression2;
                PsiExpression contents = parenthesizedExpression.getExpression();
                return this.isArithmetic(contents);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "expression";
            objectArray2[1] = "com/siyeh/ig/numeric/OverlyComplexArithmeticExpressionInspection$OverlyComplexArithmeticExpressionVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitBinaryExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPrefixExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

