/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefPackage;
import com.intellij.codeInspection.ui.ConventionOptionsPanel;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiPackageStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseGlobalInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.BaseSharedLocalInspection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageNamingConventionInspection
extends BaseGlobalInspection {
    private static final int DEFAULT_MIN_LENGTH = 3;
    private static final int DEFAULT_MAX_LENGTH = 16;
    private static final String DEFAULT_NAME = "<default>";
    @NonNls
    public String m_regex = "[a-z]*";
    public int m_minLength = 3;
    public int m_maxLength = 16;
    protected Pattern m_regexPattern = Pattern.compile(this.m_regex);

    public CommonProblemDescriptor @Nullable [] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope analysisScope, @NotNull InspectionManager inspectionManager, @NotNull GlobalInspectionContext globalInspectionContext) {
        if (refEntity == null) {
            PackageNamingConventionInspection.$$$reportNull$$$0(0);
        }
        if (analysisScope == null) {
            PackageNamingConventionInspection.$$$reportNull$$$0(1);
        }
        if (inspectionManager == null) {
            PackageNamingConventionInspection.$$$reportNull$$$0(2);
        }
        if (globalInspectionContext == null) {
            PackageNamingConventionInspection.$$$reportNull$$$0(3);
        }
        if (!(refEntity instanceof RefPackage)) {
            return null;
        }
        String name2 = StringUtil.getShortName((String)refEntity.getQualifiedName());
        if (DEFAULT_NAME.equals(name2)) {
            return null;
        }
        int length = name2.length();
        if (length == 0) {
            return null;
        }
        if (length < this.m_minLength) {
            String errorString = InspectionGadgetsBundle.message("package.naming.convention.problem.descriptor.short", name2);
            return new CommonProblemDescriptor[]{inspectionManager.createProblemDescriptor(errorString, new QuickFix[0])};
        }
        if (length > this.m_maxLength) {
            String errorString = InspectionGadgetsBundle.message("package.naming.convention.problem.descriptor.long", name2);
            return new CommonProblemDescriptor[]{inspectionManager.createProblemDescriptor(errorString, new QuickFix[0])};
        }
        Matcher matcher = this.m_regexPattern.matcher(name2);
        if (matcher.matches()) {
            return null;
        }
        String errorString = InspectionGadgetsBundle.message("package.naming.convention.problem.descriptor.regex.mismatch", name2, this.m_regex);
        return new CommonProblemDescriptor[]{inspectionManager.createProblemDescriptor(errorString, new QuickFix[0])};
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            PackageNamingConventionInspection.$$$reportNull$$$0(4);
        }
        super.readSettings(element);
        this.m_regexPattern = Pattern.compile(this.m_regex);
    }

    public JComponent createOptionsPanel() {
        return new ConventionOptionsPanel((InspectionProfileEntry)this, "m_minLength", "m_maxLength", "m_regex", "m_regexPattern", new JComponent[0]);
    }

    boolean isValid(String name2) {
        int length = name2.length();
        if (length < this.m_minLength) {
            return false;
        }
        if (this.m_maxLength > 0 && length > this.m_maxLength) {
            return false;
        }
        Matcher matcher = this.m_regexPattern.matcher(name2);
        return matcher.matches();
    }

    @Nullable
    public LocalInspectionTool getSharedLocalInspectionTool() {
        return new LocalPackageNamingConventionInspection(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refEntity";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "analysisScope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalInspectionContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/naming/PackageNamingConventionInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "readSettings";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class LocalPackageNamingConventionInspection
    extends BaseSharedLocalInspection<PackageNamingConventionInspection> {
        LocalPackageNamingConventionInspection(PackageNamingConventionInspection inspection) {
            super(inspection);
        }

        @Override
        @NotNull
        protected String buildErrorString(Object ... infos) {
            String name2 = (String)infos[0];
            if (name2.length() < ((PackageNamingConventionInspection)this.mySettingsDelegate).m_minLength) {
                String string = InspectionGadgetsBundle.message("package.naming.convention.problem.descriptor.short", name2);
                if (string == null) {
                    LocalPackageNamingConventionInspection.$$$reportNull$$$0(0);
                }
                return string;
            }
            if (name2.length() > ((PackageNamingConventionInspection)this.mySettingsDelegate).m_maxLength) {
                String string = InspectionGadgetsBundle.message("package.naming.convention.problem.descriptor.long", name2);
                if (string == null) {
                    LocalPackageNamingConventionInspection.$$$reportNull$$$0(1);
                }
                return string;
            }
            String string = InspectionGadgetsBundle.message("package.naming.convention.problem.descriptor.regex.mismatch", name2, ((PackageNamingConventionInspection)this.mySettingsDelegate).m_regex);
            if (string == null) {
                LocalPackageNamingConventionInspection.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        public BaseInspectionVisitor buildVisitor() {
            return new BaseInspectionVisitor(){

                public void visitPackageStatement(PsiPackageStatement statement) {
                    PsiJavaCodeReferenceElement reference = statement.getPackageReference();
                    if (reference == null) {
                        return;
                    }
                    String text2 = reference.getText();
                    int start = 0;
                    int index = text2.indexOf(46, start);
                    while (index > 0) {
                        String name2 = text2.substring(start, index);
                        if (!((PackageNamingConventionInspection)mySettingsDelegate).isValid(name2)) {
                            this.registerErrorAtOffset((PsiElement)reference, start, index - start, name2);
                        }
                        start = index + 1;
                        index = text2.indexOf(46, start);
                    }
                    String lastName = text2.substring(start);
                    if (!lastName.isEmpty() && !((PackageNamingConventionInspection)mySettingsDelegate).isValid(lastName)) {
                        this.registerErrorAtOffset((PsiElement)reference, start, lastName.length(), lastName);
                    }
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/PackageNamingConventionInspection$LocalPackageNamingConventionInspection", "buildErrorString"));
        }
    }
}

