/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessaryUnboxingInspection
extends BaseInspection {
    public boolean onlyReportSuperfluouslyUnboxed = false;
    @NonNls
    static final Map<String, String> s_unboxingMethods = new HashMap<String, String>(8);

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.unboxing.problem.descriptor", new Object[0]);
        if (string == null) {
            UnnecessaryUnboxingInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("unnecessary.unboxing.superfluous.option", new Object[0]), (InspectionProfileEntry)this, "onlyReportSuperfluouslyUnboxed");
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryUnboxingFix();
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return PsiUtil.isLanguageLevel5OrHigher((PsiElement)file);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryUnboxingVisitor();
    }

    static {
        s_unboxingMethods.put("java.lang.Integer", "intValue");
        s_unboxingMethods.put("java.lang.Short", "shortValue");
        s_unboxingMethods.put("java.lang.Boolean", "booleanValue");
        s_unboxingMethods.put("java.lang.Long", "longValue");
        s_unboxingMethods.put("java.lang.Byte", "byteValue");
        s_unboxingMethods.put("java.lang.Float", "floatValue");
        s_unboxingMethods.put("java.lang.Double", "doubleValue");
        s_unboxingMethods.put("java.lang.Character", "charValue");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/UnnecessaryUnboxingInspection", "buildErrorString"));
    }

    private class UnnecessaryUnboxingVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryUnboxingVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            if (expression2 == null) {
                UnnecessaryUnboxingVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression2);
            if (!this.isUnboxingExpression((PsiExpression)expression2)) {
                return;
            }
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null || this.isUnboxingNecessary((PsiExpression)expression2, qualifier)) {
                return;
            }
            this.registerError((PsiElement)expression2, new Object[0]);
        }

        private boolean isUnboxingNecessary(@NotNull PsiExpression expression2, @NotNull PsiExpression unboxedExpression) {
            PsiType expectedType;
            PsiPolyadicExpression polyadicExpression;
            if (expression2 == null) {
                UnnecessaryUnboxingVisitor.$$$reportNull$$$0(1);
            }
            if (unboxedExpression == null) {
                UnnecessaryUnboxingVisitor.$$$reportNull$$$0(2);
            }
            PsiElement parent = expression2.getParent();
            while (parent instanceof PsiParenthesizedExpression) {
                expression2 = (PsiExpression)parent;
                parent = parent.getParent();
            }
            if (parent instanceof PsiPolyadicExpression && this.isPossibleObjectComparison(expression2, polyadicExpression = (PsiPolyadicExpression)parent)) {
                return true;
            }
            if (parent instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)parent;
                PsiTypeElement typeElement = typeCastExpression.getCastType();
                if (typeElement == null) {
                    return true;
                }
                PsiType castType = typeElement.getType();
                PsiType expressionType = expression2.getType();
                if (expressionType == null || !castType.isAssignableFrom(expressionType)) {
                    return true;
                }
            } else if (parent instanceof PsiConditionalExpression) {
                PsiType type2;
                PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)parent;
                PsiExpression thenExpression2 = conditionalExpression.getThenExpression();
                if (thenExpression2 == null) {
                    return true;
                }
                PsiExpression elseExpression2 = conditionalExpression.getElseExpression();
                if (elseExpression2 == null) {
                    return true;
                }
                if (PsiTreeUtil.isAncestor((PsiElement)thenExpression2, (PsiElement)expression2, (boolean)false) ? !((type2 = elseExpression2.getType()) instanceof PsiPrimitiveType) : PsiTreeUtil.isAncestor((PsiElement)elseExpression2, (PsiElement)expression2, (boolean)false) && !((type = thenExpression2.getType()) instanceof PsiPrimitiveType)) {
                    return true;
                }
            } else if (MethodCallUtils.isNecessaryForSurroundingMethodCall(expression2, unboxedExpression)) {
                return true;
            }
            if (!LambdaUtil.isSafeLambdaReturnValueReplacement((PsiExpression)expression2, (PsiExpression)unboxedExpression)) {
                return true;
            }
            return UnnecessaryUnboxingInspection.this.onlyReportSuperfluouslyUnboxed && !((expectedType = ExpectedTypeUtils.findExpectedType(expression2, false, true)) instanceof PsiClassType);
        }

        private boolean isPossibleObjectComparison(PsiExpression expression2, PsiPolyadicExpression polyadicExpression) {
            if (!ComparisonUtils.isEqualityComparison((PsiExpression)polyadicExpression)) {
                return false;
            }
            for (PsiExpression operand2 : polyadicExpression.getOperands()) {
                if (operand2 == expression2 || operand2.getType() instanceof PsiPrimitiveType && !this.isUnboxingExpression(operand2)) continue;
                return true;
            }
            return false;
        }

        private boolean isUnboxingExpression(PsiExpression expression2) {
            if (!(expression2 instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return false;
            }
            PsiType qualifierType = qualifier.getType();
            if (qualifierType == null) {
                return false;
            }
            String qualifierTypeName = qualifierType.getCanonicalText();
            if (!s_unboxingMethods.containsKey(qualifierTypeName)) {
                return false;
            }
            String methodName = methodExpression.getReferenceName();
            String unboxingMethod = s_unboxingMethods.get(qualifierTypeName);
            return unboxingMethod.equals(methodName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unboxedExpression";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/migration/UnnecessaryUnboxingInspection$UnnecessaryUnboxingVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isUnboxingNecessary";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class UnnecessaryUnboxingFix
    extends InspectionGadgetsFix {
        private UnnecessaryUnboxingFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unnecessary.unboxing.remove.quickfix", new Object[0]);
            if (string == null) {
                UnnecessaryUnboxingFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiReferenceExpression referenceExpression;
            PsiElement element;
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)descriptor.getPsiElement();
            PsiReferenceExpression methodExpression = methodCall.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            PsiExpression strippedQualifier = PsiUtil.skipParenthesizedExprDown((PsiExpression)qualifier);
            if (strippedQualifier == null) {
                return;
            }
            CommentTracker commentTracker = new CommentTracker();
            if (strippedQualifier instanceof PsiReferenceExpression && (element = (referenceExpression = (PsiReferenceExpression)strippedQualifier).resolve()) instanceof PsiField) {
                PsiField field = (PsiField)element;
                PsiClass containingClass = field.getContainingClass();
                if (containingClass == null) {
                    return;
                }
                String classname = containingClass.getQualifiedName();
                if ("java.lang.Boolean".equals(classname)) {
                    String name2 = field.getName();
                    if ("TRUE".equals(name2)) {
                        PsiReplacementUtil.replaceExpression((PsiExpression)methodCall, "true", commentTracker);
                        return;
                    }
                    if ("FALSE".equals(name2)) {
                        PsiReplacementUtil.replaceExpression((PsiExpression)methodCall, "false", commentTracker);
                        return;
                    }
                }
            }
            String strippedQualifierText = commentTracker.text((PsiElement)strippedQualifier);
            PsiReplacementUtil.replaceExpression((PsiExpression)methodCall, strippedQualifierText, commentTracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/UnnecessaryUnboxingInspection$UnnecessaryUnboxingFix", "getFamilyName"));
        }
    }
}

