/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.junit.ReplaceAssertEqualsFix;
import com.siyeh.ig.testFrameworks.AssertHint;
import org.jetbrains.annotations.NotNull;

public class AssertEqualsMayBeAssertSameInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("assertequals.may.be.assertsame.problem.descriptor", new Object[0]);
        if (string == null) {
            AssertEqualsMayBeAssertSameInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ReplaceAssertEqualsFix("assertSame");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AssertEqualsMayBeAssertSameVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/AssertEqualsMayBeAssertSameInspection", "buildErrorString"));
    }

    private static class AssertEqualsMayBeAssertSameVisitor
    extends BaseInspectionVisitor {
        private AssertEqualsMayBeAssertSameVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            AssertHint assertHint = AssertHint.createAssertEqualsHint(expression2);
            if (assertHint == null) {
                return;
            }
            PsiExpression argument1 = assertHint.getFirstArgument();
            if (!AssertEqualsMayBeAssertSameVisitor.couldBeAssertSameArgument(argument1)) {
                return;
            }
            PsiExpression argument2 = assertHint.getSecondArgument();
            if (!AssertEqualsMayBeAssertSameVisitor.couldBeAssertSameArgument(argument2)) {
                return;
            }
            this.registerMethodCallError(expression2, new Object[0]);
        }

        private static boolean couldBeAssertSameArgument(PsiExpression expression2) {
            PsiClass argumentClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)expression2.getType());
            if (argumentClass == null) {
                return false;
            }
            if (!argumentClass.hasModifierProperty("final")) {
                return false;
            }
            PsiMethod[] methods = argumentClass.findMethodsByName("equals", true);
            PsiManager manager = expression2.getManager();
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)manager.getProject());
            PsiClass objectClass = psiFacade.findClass("java.lang.Object", argumentClass.getResolveScope());
            if (objectClass == null) {
                return false;
            }
            for (PsiMethod method : methods) {
                PsiClass containingClass = method.getContainingClass();
                if (objectClass.equals(containingClass)) continue;
                return false;
            }
            return true;
        }
    }
}

