/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.jdk;

import com.intellij.codeInsight.daemon.JavaErrorBundle;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.fixes.RenameFix;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForwardCompatibilityInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            ForwardCompatibilityInspection.$$$reportNull$$$0(0);
        }
        final LanguageLevel languageLevel = PsiUtil.getLanguageLevel((PsiElement)holder.getFile());
        return new JavaElementVisitor(){

            public void visitIdentifier(PsiIdentifier identifier) {
                String message2 = this.getIdentifierWarning(identifier);
                if (message2 != null) {
                    holder.registerProblem((PsiElement)identifier, message2, new LocalQuickFix[]{new RenameFix()});
                }
            }

            @Nullable
            private String getIdentifierWarning(PsiIdentifier identifier) {
                String name2 = identifier.getText();
                PsiElement parent = identifier.getParent();
                switch (name2) {
                    case "assert": {
                        if (!languageLevel.isLessThan(LanguageLevel.JDK_1_4) || !(parent instanceof PsiClass) && !(parent instanceof PsiMethod) && !(parent instanceof PsiVariable)) break;
                        return JavaErrorBundle.message("assert.identifier.warn", new Object[0]);
                    }
                    case "enum": {
                        if (!languageLevel.isLessThan(LanguageLevel.JDK_1_5) || !(parent instanceof PsiClass) && !(parent instanceof PsiMethod) && !(parent instanceof PsiVariable)) break;
                        return JavaErrorBundle.message("enum.identifier.warn", new Object[0]);
                    }
                    case "_": {
                        if (!languageLevel.isLessThan(LanguageLevel.JDK_1_9)) break;
                        return JavaErrorBundle.message("underscore.identifier.warn", new Object[0]);
                    }
                    case "var": {
                        if (!languageLevel.isLessThan(LanguageLevel.JDK_10) || !(parent instanceof PsiClass)) break;
                        return JavaErrorBundle.message("var.identifier.warn", new Object[0]);
                    }
                    case "yield": {
                        if (!languageLevel.isLessThan(LanguageLevel.JDK_14) || !(parent instanceof PsiClass)) break;
                        return JavaErrorBundle.message("yield.identifier.warn", new Object[0]);
                    }
                }
                return null;
            }

            public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
                PsiReferenceExpression ref = expression2.getMethodExpression();
                PsiElement nameElement = ref.getReferenceNameElement();
                if (nameElement != null && "yield".equals(nameElement.getText()) && ref.getQualifierExpression() == null && languageLevel.isLessThan(LanguageLevel.JDK_14)) {
                    PsiExpression qualifier = ExpressionUtils.getEffectiveQualifier(expression2.getMethodExpression());
                    holder.registerProblem(nameElement, JavaErrorBundle.message("yield.unqualified.method.warn", new Object[0]), new LocalQuickFix[]{qualifier == null ? null : new QualifyCallFix(), new RenameFix()});
                }
            }

            public void visitKeyword(PsiKeyword keyword) {
                PsiElement grand;
                PsiElement parent;
                String modifier;
                super.visitKeyword(keyword);
                if (languageLevel.isAtLeast(LanguageLevel.JDK_1_9) && !languageLevel.isAtLeast(LanguageLevel.JDK_10) && ("static".equals(modifier = keyword.getText()) || "transitive".equals(modifier)) && (parent = keyword.getParent()) instanceof PsiModifierList && (grand = parent.getParent()) instanceof PsiRequiresStatement && "java.base".equals(((PsiRequiresStatement)grand).getModuleName())) {
                    String message2 = JavaErrorBundle.message("module.unwanted.modifier.warn", new Object[0]);
                    LocalQuickFixAndIntentionActionOnPsiElement fix = QuickFixFactory.getInstance().createModifierListFix((PsiModifierList)parent, modifier, false, false);
                    holder.registerProblem((PsiElement)keyword, message2, new LocalQuickFix[]{fix});
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/siyeh/ig/jdk/ForwardCompatibilityInspection", "buildVisitor"));
    }

    private static class QualifyCallFix
    implements LocalQuickFix {
        private QualifyCallFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("qualify.call.fix.family.name", new Object[0]);
            if (string == null) {
                QualifyCallFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiMethodCallExpression call;
            if (project == null) {
                QualifyCallFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                QualifyCallFix.$$$reportNull$$$0(2);
            }
            if ((call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getStartElement(), PsiMethodCallExpression.class)) == null) {
                return;
            }
            PsiExpression qualifier = ExpressionUtils.getEffectiveQualifier(call.getMethodExpression());
            if (qualifier == null) {
                return;
            }
            call.getMethodExpression().setQualifierExpression(qualifier);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/jdk/ForwardCompatibilityInspection$QualifyCallFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/jdk/ForwardCompatibilityInspection$QualifyCallFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

