/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.AnnotateMethodFix;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.java15api.Java15APIUsageInspection;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.module.EffectiveLanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.impl.scopes.ModulesScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.JavaPsiRecordUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.JavaOverridingMethodUtil;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MissingOverrideAnnotationInspection
extends AbstractBaseJavaLocalInspectionTool
implements CleanupLocalInspectionTool {
    private static final String OVERRIDE_SHORT_NAME = StringUtil.getShortName((String)"java.lang.Override");
    public boolean ignoreObjectMethods = true;
    public boolean ignoreAnonymousClassMethods;

    @NotNull
    public String getID() {
        return "override";
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new InspectionGadgetsFix(){
            private final AnnotateMethodFix myFix = new AnnotateMethodFix("java.lang.Override", new String[0]);

            @Override
            protected void doFix(Project project, ProblemDescriptor descriptor) {
                this.myFix.applyFix(project, descriptor);
            }

            @Nls
            @NotNull
            public String getFamilyName() {
                String string = this.myFix.getFamilyName();
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/MissingOverrideAnnotationInspection$1", "getFamilyName"));
            }
        };
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    protected String buildErrorString(Object ... infos) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    protected BaseInspectionVisitor buildVisitor() {
        throw new UnsupportedOperationException();
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel2 = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel2.addCheckbox(InspectionGadgetsBundle.message("ignore.equals.hashcode.and.tostring", new Object[0]), "ignoreObjectMethods");
        panel2.addCheckbox(InspectionGadgetsBundle.message("ignore.methods.in.anonymous.classes", new Object[0]), "ignoreAnonymousClassMethods");
        return panel2;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            MissingOverrideAnnotationInspection.$$$reportNull$$$0(0);
        }
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                MissingOverrideAnnotationInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        return new JavaElementVisitor(){

            public void visitMethod(@NotNull PsiMethod method) {
                if (method == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (method.getNameIdentifier() == null) {
                    return;
                }
                if (method.isConstructor()) {
                    return;
                }
                if (method.hasModifierProperty("private") || method.hasModifierProperty("static")) {
                    return;
                }
                PsiClass methodClass = method.getContainingClass();
                if (methodClass == null) {
                    return;
                }
                if (MissingOverrideAnnotationInspection.this.ignoreObjectMethods && (MethodUtils.isHashCode(method) || MethodUtils.isEquals(method) || MethodUtils.isToString(method))) {
                    return;
                }
                InspectionResult result = new InspectionResult();
                this.checkMissingOverride(method, result);
                if (isOnTheFly) {
                    this.checkMissingOverrideInOverriders(method, result);
                }
                if (result.requireAnnotation || result.hierarchyAnnotated == ThreeState.NO) {
                    holder.registerProblem((PsiElement)method.getNameIdentifier(), InspectionGadgetsBundle.message(result.requireAnnotation ? "missing.override.annotation.problem.descriptor" : "missing.override.annotation.in.overriding.problem.descriptor", new Object[0]), new LocalQuickFix[]{MissingOverrideAnnotationInspection.createAnnotateFix(result.requireAnnotation, result.hierarchyAnnotated)});
                }
            }

            private void checkMissingOverrideInOverriders(@NotNull PsiMethod method, @NotNull InspectionResult result) {
                if (method == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (!PsiUtil.canBeOverridden((PsiMethod)method)) {
                    return;
                }
                Project project = method.getProject();
                LanguageLevel minimal = Objects.requireNonNull(method.getContainingClass()).isInterface() ? LanguageLevel.JDK_1_6 : LanguageLevel.JDK_1_5;
                GlobalSearchScope scope = MissingOverrideAnnotationInspection.getLanguageLevelScope(minimal, project);
                if (scope == null) {
                    return;
                }
                int paramCount = method.getParameterList().getParametersCount();
                Predicate<PsiMethod> preFilter = m -> m.getParameterList().getParametersCount() == paramCount && !JavaOverridingMethodUtil.containsAnnotationWithName((PsiModifierListOwner)m, OVERRIDE_SHORT_NAME);
                Stream<PsiMethod> overridingMethods = JavaOverridingMethodUtil.getOverridingMethodsIfCheapEnough(method, scope, preFilter);
                if (overridingMethods == null) {
                    return;
                }
                result.hierarchyAnnotated = ThreeState.fromBoolean((!overridingMethods.findAny().isPresent() ? 1 : 0) != 0);
            }

            private void checkMissingOverride(@NotNull PsiMethod method, @NotNull InspectionResult result) {
                if (method == null) {
                    2.$$$reportNull$$$0(3);
                }
                if (result == null) {
                    2.$$$reportNull$$$0(4);
                }
                PsiClass methodClass = method.getContainingClass();
                if (MissingOverrideAnnotationInspection.this.ignoreAnonymousClassMethods && methodClass instanceof PsiAnonymousClass) {
                    return;
                }
                if (this.hasOverrideAnnotation((PsiModifierListOwner)method)) {
                    return;
                }
                LanguageLevel level = PsiUtil.getLanguageLevel((PsiElement)method);
                if (level != LanguageLevel.JDK_14_PREVIEW && JavaPsiRecordUtil.getRecordComponentForAccessor(method) != null) {
                    result.requireAnnotation = true;
                    return;
                }
                boolean useJdk6Rules = level.isAtLeast(LanguageLevel.JDK_1_6);
                if (useJdk6Rules ? !this.isJdk6Override(method, methodClass) : !this.isJdk5Override(method, methodClass)) {
                    return;
                }
                result.requireAnnotation = true;
            }

            private boolean hasOverrideAnnotation(PsiModifierListOwner element) {
                PsiModifierList modifierList = element.getModifierList();
                return modifierList != null && modifierList.hasAnnotation("java.lang.Override");
            }

            private boolean isJdk6Override(PsiMethod method, PsiClass methodClass) {
                PsiMethod[] superMethods = method.findSuperMethods();
                boolean hasSupers = false;
                for (PsiMethod superMethod : superMethods) {
                    PsiClass superClass = superMethod.getContainingClass();
                    if (this.ignoreSuperMethod(method, methodClass, superMethod, superClass)) continue;
                    hasSupers = true;
                    if (superMethod.hasModifierProperty("protected")) continue;
                    return true;
                }
                return hasSupers && !methodClass.isInterface();
            }

            private boolean isJdk5Override(PsiMethod method, PsiClass methodClass) {
                PsiMethod[] superMethods;
                for (PsiMethod superMethod : superMethods = method.findSuperMethods()) {
                    PsiClass superClass = superMethod.getContainingClass();
                    if (this.ignoreSuperMethod(method, methodClass, superMethod, superClass) || superClass.isInterface() || methodClass.isInterface() && superMethod.hasModifierProperty("protected")) continue;
                    return true;
                }
                return false;
            }

            @Contract(value="_, _, _,null -> true")
            private boolean ignoreSuperMethod(PsiMethod method, PsiClass methodClass, PsiMethod superMethod, PsiClass superClass) {
                return !InheritanceUtil.isInheritorOrSelf((PsiClass)methodClass, (PsiClass)superClass, (boolean)true) || Java15APIUsageInspection.getLastIncompatibleLanguageLevel((PsiMember)superMethod, PsiUtil.getLanguageLevel((PsiElement)method)) != null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "method";
                        break;
                    }
                    case 2: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "result";
                        break;
                    }
                }
                objectArray2[1] = "com/siyeh/ig/inheritance/MissingOverrideAnnotationInspection$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethod";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkMissingOverrideInOverriders";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkMissingOverride";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    private static AnnotateMethodFix createAnnotateFix(final boolean requireAnnotation, final ThreeState hierarchyAnnotated) {
        return new AnnotateMethodFix("java.lang.Override", new String[0]){

            @Override
            protected boolean annotateSelf() {
                return requireAnnotation;
            }

            @Override
            protected boolean annotateOverriddenMethods() {
                return hierarchyAnnotated == ThreeState.NO;
            }
        };
    }

    @Nullable
    private static GlobalSearchScope getLanguageLevelScope(@NotNull LanguageLevel _minimal, @NotNull Project project) {
        if (_minimal == null) {
            MissingOverrideAnnotationInspection.$$$reportNull$$$0(2);
        }
        if (project == null) {
            MissingOverrideAnnotationInspection.$$$reportNull$$$0(3);
        }
        Map map2 = (Map)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            ConcurrentMap result = ConcurrentFactoryMap.createMap(minimal -> {
                Set modules = ((StreamEx)StreamEx.of((Object[])ModuleManager.getInstance((Project)project).getModules()).filter(m -> EffectiveLanguageLevelUtil.getEffectiveLanguageLevel((Module)m).isAtLeast(minimal))).toSet();
                return modules == null ? null : new ModulesScope(modules, project);
            });
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{ProjectRootModificationTracker.getInstance((Project)project)});
        });
        return (GlobalSearchScope)map2.get(_minimal);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/inheritance/MissingOverrideAnnotationInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_minimal";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/inheritance/MissingOverrideAnnotationInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageLevelScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class InspectionResult {
        private boolean requireAnnotation;
        private ThreeState hierarchyAnnotated = ThreeState.UNSURE;

        private InspectionResult() {
        }
    }
}

