/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.dependency;

import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefPackage;
import com.intellij.openapi.util.Key;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class DependencyUtils {
    private static final Key<Set<RefClass>> DEPENDENT_CLASSES_KEY = new Key("DEPENDENT_CLASSES");
    private static final Key<Set<RefClass>> DEPENDENCY_CLASSES_KEY = new Key("DEPENDENCY_CLASSES");
    private static final Key<Set<RefClass>> TRANSITIVE_DEPENDENT_CLASSES_KEY = new Key("TRANSITIVE_DEPENDENT_CLASSES");
    private static final Key<Set<RefClass>> TRANSITIVE_DEPENDENCY_CLASSES_KEY = new Key("TRANSITIVE_DEPENDENCY_CLASSES");
    private static final Key<Set<RefPackage>> DEPENDENT_PACKAGES_KEY = new Key("DEPENDENT_PACKAGES");
    private static final Key<Set<RefPackage>> DEPENDENCY_PACKAGES_KEY = new Key("DEPENDENCY_PACKAGES");
    private static final Key<Set<RefPackage>> TRANSITIVE_DEPENDENT_PACKAGES_KEY = new Key("TRANSITIVE_DEPENDENT_PACKAGES");
    private static final Key<Set<RefPackage>> TRANSITIVE_DEPENDENCY_PACKAGES_KEY = new Key("TRANSITIVE_DEPENDENCY_PACKAGES");

    private DependencyUtils() {
    }

    public static Set<RefClass> calculateDependenciesForClass(RefClass refClass) {
        Set dependencies = (Set)refClass.getUserData(DEPENDENCY_CLASSES_KEY);
        if (dependencies != null) {
            return dependencies;
        }
        HashSet<RefClass> newDependencies = new HashSet<RefClass>();
        DependencyUtils.tabulateDependencyClasses((RefJavaElement)refClass, newDependencies);
        newDependencies.remove(refClass);
        refClass.putUserData(DEPENDENCY_CLASSES_KEY, newDependencies);
        return newDependencies;
    }

    private static void tabulateDependencyClasses(RefJavaElement element, Set<? super RefClass> dependencies) {
        DependencyUtils.addOwnerClassesToSet(element.getOutReferences(), dependencies);
        DependencyUtils.addOwnerClassesToSet(element.getOutTypeReferences(), dependencies);
        List children = element.getChildren();
        for (RefEntity child : children) {
            if (!(child instanceof RefJavaElement) || child instanceof RefClass) continue;
            DependencyUtils.tabulateDependencyClasses((RefJavaElement)child, dependencies);
        }
    }

    private static void addOwnerClassesToSet(Collection<? extends RefElement> references, Set<? super RefClass> set) {
        RefJavaUtil refUtil = RefJavaUtil.getInstance();
        for (RefElement refElement : references) {
            RefClass refClass = refElement instanceof RefClass ? (RefClass)refElement : refUtil.getOwnerClass(refElement);
            if (refClass == null || refClass.isAnonymous() || refClass.isLocalClass()) continue;
            set.add((RefClass)refClass);
        }
    }

    static Set<RefClass> calculateTransitiveDependenciesForClass(RefClass refClass) {
        Set dependencies = (Set)refClass.getUserData(TRANSITIVE_DEPENDENCY_CLASSES_KEY);
        if (dependencies != null) {
            return dependencies;
        }
        HashSet<RefClass> newDependencies = new HashSet<RefClass>();
        DependencyUtils.tabulateTransitiveDependencyClasses(refClass, newDependencies);
        refClass.putUserData(TRANSITIVE_DEPENDENCY_CLASSES_KEY, newDependencies);
        return newDependencies;
    }

    private static void tabulateTransitiveDependencyClasses(RefClass refClass, Set<? super RefClass> newDependencies) {
        LinkedList<RefClass> pendingClasses = new LinkedList<RefClass>();
        pendingClasses.addLast(refClass);
        HashSet<RefClass> processedClasses = new HashSet<RefClass>();
        while (!pendingClasses.isEmpty()) {
            RefClass classToProcess = (RefClass)pendingClasses.removeFirst();
            newDependencies.add((RefClass)classToProcess);
            processedClasses.add(classToProcess);
            Set<RefClass> dependencies = DependencyUtils.calculateDependenciesForClass(classToProcess);
            for (RefClass dependency : dependencies) {
                if (pendingClasses.contains(dependency) || processedClasses.contains(dependency)) continue;
                pendingClasses.addLast(dependency);
            }
        }
        newDependencies.remove(refClass);
    }

    public static Set<RefClass> calculateDependentsForClass(RefClass refClass) {
        Set dependents = (Set)refClass.getUserData(DEPENDENT_CLASSES_KEY);
        if (dependents != null) {
            return dependents;
        }
        HashSet<RefClass> newDependents = new HashSet<RefClass>();
        DependencyUtils.tabulateDependentClasses((RefElement)refClass, newDependents);
        newDependents.remove(refClass);
        refClass.putUserData(DEPENDENT_CLASSES_KEY, newDependents);
        return newDependents;
    }

    private static void tabulateDependentClasses(RefElement element, Set<? super RefClass> dependents) {
        DependencyUtils.addOwnerClassesToSet(element.getInReferences(), dependents);
        if (element instanceof RefClass) {
            RefClass refClass = (RefClass)element;
            DependencyUtils.addOwnerClassesToSet(refClass.getInTypeReferences(), dependents);
        }
        List children = element.getChildren();
        for (RefEntity child : children) {
            if (!(child instanceof RefElement) || child instanceof RefClass) continue;
            DependencyUtils.tabulateDependentClasses((RefElement)child, dependents);
        }
    }

    static Set<RefClass> calculateTransitiveDependentsForClass(RefClass refClass) {
        Set dependents = (Set)refClass.getUserData(TRANSITIVE_DEPENDENT_CLASSES_KEY);
        if (dependents != null) {
            return dependents;
        }
        HashSet<RefClass> newDependents = new HashSet<RefClass>();
        DependencyUtils.tabulateTransitiveDependentClasses(refClass, newDependents);
        refClass.putUserData(TRANSITIVE_DEPENDENT_CLASSES_KEY, newDependents);
        return newDependents;
    }

    private static void tabulateTransitiveDependentClasses(RefClass refClass, Set<? super RefClass> newDependents) {
        LinkedList<RefClass> pendingClasses = new LinkedList<RefClass>();
        pendingClasses.addLast(refClass);
        HashSet<RefClass> processedClasses = new HashSet<RefClass>();
        while (!pendingClasses.isEmpty()) {
            RefClass classToProcess = (RefClass)pendingClasses.removeFirst();
            newDependents.add((RefClass)classToProcess);
            processedClasses.add(classToProcess);
            Set<RefClass> dependents = DependencyUtils.calculateDependentsForClass(classToProcess);
            for (RefClass dependent : dependents) {
                if (pendingClasses.contains(dependent) || processedClasses.contains(dependent)) continue;
                pendingClasses.addLast(dependent);
            }
        }
        newDependents.remove(refClass);
    }

    private static Set<RefPackage> calculateDependenciesForPackage(RefPackage refPackage) {
        Set dependencies = (Set)refPackage.getUserData(DEPENDENCY_PACKAGES_KEY);
        if (dependencies != null) {
            return dependencies;
        }
        HashSet<RefPackage> newDependencies = new HashSet<RefPackage>();
        DependencyUtils.tabulateDependencyPackages((RefEntity)refPackage, newDependencies);
        newDependencies.remove(refPackage);
        refPackage.putUserData(DEPENDENCY_PACKAGES_KEY, newDependencies);
        return newDependencies;
    }

    private static void tabulateDependencyPackages(RefEntity entity, Set<? super RefPackage> dependencies) {
        if (entity instanceof RefElement) {
            RefElement element = (RefElement)entity;
            Collection references = element.getOutReferences();
            for (RefElement reference : references) {
                RefPackage refPackage = RefJavaUtil.getPackage((RefEntity)reference);
                if (refPackage == null) continue;
                dependencies.add((RefPackage)refPackage);
            }
        }
        List children = entity.getChildren();
        for (RefEntity child : children) {
            if (child instanceof RefPackage) continue;
            DependencyUtils.tabulateDependencyPackages(child, dependencies);
        }
    }

    private static Set<RefPackage> calculateDependentsForPackage(RefPackage refPackage) {
        Set dependents = (Set)refPackage.getUserData(DEPENDENT_PACKAGES_KEY);
        if (dependents != null) {
            return dependents;
        }
        HashSet<RefPackage> newDependents = new HashSet<RefPackage>();
        DependencyUtils.tabulateDependentPackages((RefEntity)refPackage, newDependents);
        newDependents.remove(refPackage);
        refPackage.putUserData(DEPENDENT_PACKAGES_KEY, newDependents);
        return newDependents;
    }

    private static void tabulateDependentPackages(RefEntity entity, Set<? super RefPackage> dependents) {
        if (entity instanceof RefElement) {
            RefElement element = (RefElement)entity;
            Collection references = element.getInReferences();
            for (RefElement reference : references) {
                RefPackage refPackage = RefJavaUtil.getPackage((RefEntity)reference);
                if (refPackage == null) continue;
                dependents.add((RefPackage)refPackage);
            }
        }
        List children = entity.getChildren();
        for (RefEntity child : children) {
            if (child instanceof RefPackage) continue;
            DependencyUtils.tabulateDependentPackages(child, dependents);
        }
    }

    static Set<RefPackage> calculateTransitiveDependentsForPackage(RefPackage refPackage) {
        Set dependents = (Set)refPackage.getUserData(TRANSITIVE_DEPENDENT_PACKAGES_KEY);
        if (dependents != null) {
            return dependents;
        }
        HashSet<RefPackage> newDependents = new HashSet<RefPackage>();
        DependencyUtils.tabulateTransitiveDependentPackages(refPackage, newDependents);
        refPackage.putUserData(TRANSITIVE_DEPENDENT_PACKAGES_KEY, newDependents);
        return newDependents;
    }

    private static void tabulateTransitiveDependentPackages(RefPackage refPackage, Set<? super RefPackage> newDependents) {
        LinkedList<RefPackage> pendingPackages = new LinkedList<RefPackage>();
        pendingPackages.addLast(refPackage);
        HashSet<RefPackage> processedPackages = new HashSet<RefPackage>();
        while (!pendingPackages.isEmpty()) {
            RefPackage packageToProcess = (RefPackage)pendingPackages.removeFirst();
            newDependents.add((RefPackage)packageToProcess);
            processedPackages.add(packageToProcess);
            Set<RefPackage> dependents = DependencyUtils.calculateDependentsForPackage(packageToProcess);
            for (RefPackage dependent : dependents) {
                if (pendingPackages.contains(dependent) || processedPackages.contains(dependent)) continue;
                pendingPackages.addLast(dependent);
            }
        }
        newDependents.remove(refPackage);
    }

    static Set<RefPackage> calculateTransitiveDependenciesForPackage(RefPackage refPackage) {
        Set dependencies = (Set)refPackage.getUserData(TRANSITIVE_DEPENDENCY_PACKAGES_KEY);
        if (dependencies != null) {
            return dependencies;
        }
        HashSet<RefPackage> newDependencies = new HashSet<RefPackage>();
        DependencyUtils.tabulateTransitiveDependencyPackages(refPackage, newDependencies);
        refPackage.putUserData(TRANSITIVE_DEPENDENCY_PACKAGES_KEY, newDependencies);
        return newDependencies;
    }

    private static void tabulateTransitiveDependencyPackages(RefPackage refPackage, Set<? super RefPackage> newDependencies) {
        LinkedList<RefPackage> pendingPackages = new LinkedList<RefPackage>();
        pendingPackages.addLast(refPackage);
        HashSet<RefPackage> processedPackages = new HashSet<RefPackage>();
        while (!pendingPackages.isEmpty()) {
            RefPackage packageToProcess = (RefPackage)pendingPackages.removeFirst();
            newDependencies.add((RefPackage)packageToProcess);
            processedPackages.add(packageToProcess);
            Set<RefPackage> dependencies = DependencyUtils.calculateDependenciesForPackage(packageToProcess);
            for (RefPackage dependency : dependencies) {
                if (pendingPackages.contains(dependency) || processedPackages.contains(dependency)) continue;
                pendingPackages.addLast(dependency);
            }
        }
        newDependencies.remove(refPackage);
    }
}

