/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.ContractValue;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RemoveRedundantPolyadicOperandFix;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PointlessNullCheckInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiMethodCallExpression parent = Objects.requireNonNull((PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)infos[1]), PsiMethodCallExpression.class));
        String string = InspectionGadgetsBundle.message("pointless.nullcheck.problem.descriptor.call", parent.getMethodExpression().getReferenceName());
        if (string == null) {
            PointlessNullCheckInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PointlessNullCheckVisitor();
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiExpression expression2 = (PsiExpression)infos[0];
        return new RemoveRedundantPolyadicOperandFix(expression2.getText());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/PointlessNullCheckInspection", "buildErrorString"));
    }

    private static class PointlessNullCheckVisitor
    extends BaseInspectionVisitor {
        private PointlessNullCheckVisitor() {
        }

        public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
            super.visitPolyadicExpression(expression2);
            IElementType operationTokenType = expression2.getOperationTokenType();
            if (operationTokenType.equals(JavaTokenType.ANDAND)) {
                this.checkAndChain(expression2);
            } else if (operationTokenType.equals(JavaTokenType.OROR)) {
                this.checkOrChain(expression2);
            }
        }

        private void checkOrChain(PsiPolyadicExpression expression2) {
            PsiExpression[] operands2 = expression2.getOperands();
            for (int i = 0; i < operands2.length - 1; ++i) {
                IElementType tokenType;
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)operands2[i]), PsiBinaryExpression.class);
                if (binaryExpression == null || !(tokenType = binaryExpression.getOperationTokenType()).equals(JavaTokenType.EQEQ)) continue;
                for (int j = i + 1; j < operands2.length; ++j) {
                    PsiExpression implicitCheckCandidate = BoolUtils.getNegated(PsiUtil.skipParenthesizedExprDown((PsiExpression)operands2[j]));
                    if (!this.checkExpressions(operands2, i, j, binaryExpression, implicitCheckCandidate)) continue;
                    return;
                }
            }
        }

        private void checkAndChain(PsiPolyadicExpression expression2) {
            PsiExpression[] operands2 = expression2.getOperands();
            for (int i = 0; i < operands2.length - 1; ++i) {
                IElementType tokenType;
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)operands2[i]), PsiBinaryExpression.class);
                if (binaryExpression == null || !(tokenType = binaryExpression.getOperationTokenType()).equals(JavaTokenType.NE)) continue;
                for (int j = i + 1; j < operands2.length; ++j) {
                    PsiExpression implicitCheckCandidate = PsiUtil.skipParenthesizedExprDown((PsiExpression)operands2[j]);
                    if (!this.checkExpressions(operands2, i, j, binaryExpression, implicitCheckCandidate)) continue;
                    return;
                }
            }
        }

        private boolean checkExpressions(PsiExpression[] operands2, int i, int j, PsiBinaryExpression binaryExpression, PsiExpression implicitCheckCandidate) {
            PsiReferenceExpression explicitCheckReference = PointlessNullCheckVisitor.getReferenceFromNullCheck(binaryExpression);
            if (explicitCheckReference == null) {
                return false;
            }
            PsiVariable variable = (PsiVariable)ObjectUtils.tryCast((Object)explicitCheckReference.resolve(), PsiVariable.class);
            if (variable == null) {
                return false;
            }
            PsiReferenceExpression implicitCheckReference = this.getReferenceFromImplicitNullCheckExpression(implicitCheckCandidate);
            if (implicitCheckReference == null || !implicitCheckReference.isReferenceTo((PsiElement)variable)) {
                return false;
            }
            if (PointlessNullCheckVisitor.isVariableUsed(operands2, i, j, variable)) {
                return false;
            }
            this.registerError((PsiElement)binaryExpression, binaryExpression, implicitCheckReference);
            return true;
        }

        private static boolean isVariableUsed(PsiExpression[] operands2, int i, int j, PsiVariable variable) {
            return Arrays.stream(operands2, i + 1, j).anyMatch(op -> VariableAccessUtils.variableIsUsed(variable, (PsiElement)op));
        }

        @Nullable
        private static PsiReferenceExpression getReferenceFromNullCheck(PsiBinaryExpression expression2) {
            PsiExpression comparedWithNull = ExpressionUtils.getValueComparedWithNull(expression2);
            return (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)comparedWithNull), PsiReferenceExpression.class);
        }

        @Nullable
        private PsiReferenceExpression getReferenceFromImplicitNullCheckExpression(PsiExpression expression2) {
            PsiReferenceExpression checked = PointlessNullCheckVisitor.getReferenceFromBooleanCall(expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2));
            if (checked == null) {
                checked = this.getReferenceFromOrChain(expression2);
            }
            return checked;
        }

        @Nullable
        private static PsiReferenceExpression getReferenceFromBooleanCall(PsiExpression expression2) {
            List<? extends MethodContract> contracts2;
            if (!(expression2 instanceof PsiMethodCallExpression)) {
                return null;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression2;
            if (!PsiType.BOOLEAN.equals((Object)call.getType())) {
                return null;
            }
            PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
            if (qualifier != null && SideEffectChecker.mayHaveSideEffects(qualifier)) {
                return null;
            }
            PsiMethod method = call.resolveMethod();
            if (method == null) {
                return null;
            }
            if (MethodUtils.isEquals(method)) {
                StandardMethodContract.ValueConstraint[] nullArg = new StandardMethodContract.ValueConstraint[]{StandardMethodContract.ValueConstraint.NULL_VALUE};
                contracts2 = Collections.singletonList(new StandardMethodContract(nullArg, ContractReturnValue.returnFalse()));
            } else {
                contracts2 = JavaMethodContractUtil.getMethodCallContracts(method, (PsiCallExpression)call);
            }
            if (contracts2.isEmpty()) {
                return null;
            }
            MethodContract contract = (MethodContract)ObjectUtils.tryCast((Object)contracts2.get(0), StandardMethodContract.class);
            if (contract == null || !contract.getReturnValue().equals(ContractReturnValue.returnFalse())) {
                return null;
            }
            ContractValue condition2 = (ContractValue)ContainerUtil.getOnlyItem(contract.getConditions());
            if (condition2 == null) {
                return null;
            }
            int idx = condition2.getNullCheckedArgument(true).orElse(-1);
            if (idx == -1) {
                return null;
            }
            PsiExpression[] args = ((PsiMethodCallExpression)expression2).getArgumentList().getExpressions();
            if (args.length <= idx || method.isVarArgs() && idx == args.length - 1) {
                return null;
            }
            PsiReferenceExpression reference = (PsiReferenceExpression)ObjectUtils.tryCast((Object)args[idx], PsiReferenceExpression.class);
            if (reference == null) {
                return null;
            }
            PsiVariable target = (PsiVariable)ObjectUtils.tryCast((Object)reference.resolve(), PsiVariable.class);
            if (target == null) {
                return null;
            }
            if (!SyntaxTraverser.psiTraverser((PsiElement)call).filter(PsiReference.class).filter(ref -> !reference.equals(ref) && ref.isReferenceTo((PsiElement)target)).isEmpty()) {
                return null;
            }
            if (Stream.of(args).anyMatch(SideEffectChecker::mayHaveSideEffects)) {
                return null;
            }
            return reference;
        }

        @Nullable
        private PsiReferenceExpression getReferenceFromOrChain(PsiExpression expression2) {
            if (!(expression2 instanceof PsiPolyadicExpression)) {
                return null;
            }
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression2;
            IElementType tokenType = polyadicExpression.getOperationTokenType();
            if (JavaTokenType.OROR != tokenType) {
                return null;
            }
            PsiExpression[] operands2 = polyadicExpression.getOperands();
            PsiReferenceExpression referenceExpression = this.getReferenceFromImplicitNullCheckExpression(operands2[0]);
            if (referenceExpression == null) {
                return null;
            }
            PsiVariable variable = (PsiVariable)ObjectUtils.tryCast((Object)referenceExpression.resolve(), PsiVariable.class);
            if (variable == null) {
                return null;
            }
            int operandsLength = operands2.length;
            for (int i = 1; i < operandsLength; ++i) {
                PsiReferenceExpression reference2 = this.getReferenceFromImplicitNullCheckExpression(operands2[i]);
                if (reference2 != null && reference2.isReferenceTo((PsiElement)variable)) continue;
                return null;
            }
            return referenceExpression;
        }
    }
}

