/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.SpecialAnnotationsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Query;
import com.intellij.util.ui.CheckBox;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.AddToIgnoreIfAnnotatedByListQuickFix;
import com.siyeh.ig.psiutils.UtilityClassUtil;
import com.siyeh.ig.ui.ExternalizableStringSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UtilityClassWithoutPrivateConstructorInspection
extends BaseInspection {
    public final ExternalizableStringSet ignorableAnnotations = new ExternalizableStringSet(new String[0]);
    public boolean ignoreClassesWithOnlyMain = false;

    @Nullable
    public JComponent createOptionsPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        JPanel annotationsPanel = SpecialAnnotationsUtil.createSpecialAnnotationsListControl((List<String>)((Object)this.ignorableAnnotations), InspectionGadgetsBundle.message("ignore.if.annotated.by", new Object[0]));
        panel2.add((Component)annotationsPanel, "Center");
        CheckBox checkBox = new CheckBox(InspectionGadgetsBundle.message("utility.class.without.private.constructor.option", new Object[0]), (InspectionProfileEntry)this, "ignoreClassesWithOnlyMain");
        panel2.add((Component)checkBox, "South");
        return panel2;
    }

    @Override
    protected InspectionGadgetsFix @NotNull [] buildFixes(Object ... infos) {
        ArrayList<InspectionGadgetsFix> fixes = new ArrayList<InspectionGadgetsFix>();
        PsiClass aClass = (PsiClass)infos[0];
        PsiMethod constructor = UtilityClassWithoutPrivateConstructorInspection.getNullArgConstructor(aClass);
        boolean isOnTheFly = (Boolean)infos[1];
        if (constructor == null) {
            if (isOnTheFly || !UtilityClassWithoutPrivateConstructorInspection.hasImplicitConstructorUsage(aClass)) {
                fixes.add(new CreateEmptyPrivateConstructor());
            }
        } else {
            Query query = ReferencesSearch.search((PsiElement)constructor, (SearchScope)constructor.getUseScope());
            PsiReference reference = (PsiReference)query.findFirst();
            if (reference == null) {
                fixes.add(new MakeConstructorPrivateFix());
            }
        }
        AddToIgnoreIfAnnotatedByListQuickFix.build((PsiModifierListOwner)aClass, (List<String>)((Object)this.ignorableAnnotations), fixes);
        InspectionGadgetsFix[] inspectionGadgetsFixArray = fixes.toArray(InspectionGadgetsFix.EMPTY_ARRAY);
        if (inspectionGadgetsFixArray == null) {
            UtilityClassWithoutPrivateConstructorInspection.$$$reportNull$$$0(0);
        }
        return inspectionGadgetsFixArray;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("utility.class.without.private.constructor.problem.descriptor", new Object[0]);
        if (string == null) {
            UtilityClassWithoutPrivateConstructorInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UtilityClassWithoutPrivateConstructorVisitor();
    }

    private static boolean hasImplicitConstructorUsage(PsiClass aClass) {
        Query query = ReferencesSearch.search((PsiElement)aClass, (SearchScope)aClass.getUseScope());
        for (PsiReference reference : query) {
            PsiElement element;
            PsiElement context;
            if (reference == null || !((context = (element = reference.getElement()).getParent()) instanceof PsiNewExpression)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    static PsiMethod getNullArgConstructor(PsiClass aClass) {
        PsiMethod[] constructors;
        for (PsiMethod constructor : constructors = aClass.getConstructors()) {
            PsiParameterList params = constructor.getParameterList();
            if (!params.isEmpty()) continue;
            return constructor;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/classlayout/UtilityClassWithoutPrivateConstructorInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class UtilityClassWithoutPrivateConstructorVisitor
    extends BaseInspectionVisitor {
        private UtilityClassWithoutPrivateConstructorVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                UtilityClassWithoutPrivateConstructorVisitor.$$$reportNull$$$0(0);
            }
            if (aClass.hasModifierProperty("abstract")) {
                return;
            }
            if (!UtilityClassUtil.isUtilityClass(aClass)) {
                return;
            }
            if (UtilityClassWithoutPrivateConstructorInspection.this.ignoreClassesWithOnlyMain && this.hasOnlyMain(aClass)) {
                return;
            }
            if (this.hasPrivateConstructor(aClass)) {
                return;
            }
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)aClass, (Collection)((Object)UtilityClassWithoutPrivateConstructorInspection.this.ignorableAnnotations), (int)0)) {
                return;
            }
            if (aClass.hasModifierProperty("private") && aClass.getConstructors().length == 0) {
                return;
            }
            GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)aClass.getProject());
            Query query = ClassInheritorsSearch.search((PsiClass)aClass, (SearchScope)scope, (boolean)true);
            PsiClass subclass = (PsiClass)query.findFirst();
            if (subclass != null) {
                return;
            }
            this.registerClassError(aClass, aClass, this.isOnTheFly());
        }

        private boolean hasOnlyMain(PsiClass aClass) {
            PsiMethod[] methods = aClass.getMethods();
            if (methods.length == 0) {
                return false;
            }
            for (PsiMethod method : methods) {
                if (method.isConstructor()) continue;
                if (!method.hasModifierProperty("static")) {
                    return false;
                }
                if (method.hasModifierProperty("private")) continue;
                if (!method.hasModifierProperty("public")) {
                    return false;
                }
                String name2 = method.getName();
                if (!name2.equals("main")) {
                    return false;
                }
                PsiType returnType = method.getReturnType();
                if (!PsiType.VOID.equals((Object)returnType)) {
                    return false;
                }
                PsiParameterList parameterList = method.getParameterList();
                if (parameterList.getParametersCount() != 1) {
                    return false;
                }
                PsiParameter[] parameters2 = parameterList.getParameters();
                PsiParameter parameter2 = parameters2[0];
                PsiType type2 = parameter2.getType();
                if (type2.equalsToText("java.lang.String[]")) continue;
                return false;
            }
            return true;
        }

        boolean hasPrivateConstructor(PsiClass aClass) {
            PsiMethod[] constructors;
            for (PsiMethod constructor : constructors = aClass.getConstructors()) {
                if (!constructor.hasModifierProperty("private")) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/classlayout/UtilityClassWithoutPrivateConstructorInspection$UtilityClassWithoutPrivateConstructorVisitor", "visitClass"));
        }
    }

    private static class MakeConstructorPrivateFix
    extends InspectionGadgetsFix {
        private MakeConstructorPrivateFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("utility.class.without.private.constructor.make.quickfix", new Object[0]);
            if (string == null) {
                MakeConstructorPrivateFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiMethod[] constructors;
            PsiElement classNameIdentifier = descriptor.getPsiElement();
            PsiElement parent = classNameIdentifier.getParent();
            if (!(parent instanceof PsiClass)) {
                return;
            }
            PsiClass aClass = (PsiClass)parent;
            for (PsiMethod constructor : constructors = aClass.getConstructors()) {
                PsiParameterList parameterList = constructor.getParameterList();
                if (!parameterList.isEmpty()) continue;
                PsiModifierList modifiers = constructor.getModifierList();
                modifiers.setModifierProperty("public", false);
                modifiers.setModifierProperty("protected", false);
                modifiers.setModifierProperty("private", true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/UtilityClassWithoutPrivateConstructorInspection$MakeConstructorPrivateFix", "getFamilyName"));
        }
    }

    protected static class CreateEmptyPrivateConstructor
    extends InspectionGadgetsFix {
        protected CreateEmptyPrivateConstructor() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("utility.class.without.private.constructor.create.quickfix", new Object[0]);
            if (string == null) {
                CreateEmptyPrivateConstructor.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement classNameIdentifier = descriptor.getPsiElement();
            PsiElement parent = classNameIdentifier.getParent();
            if (!(parent instanceof PsiClass)) {
                return;
            }
            PsiClass aClass = (PsiClass)parent;
            if (this.isOnTheFly() && UtilityClassWithoutPrivateConstructorInspection.hasImplicitConstructorUsage(aClass)) {
                SwingUtilities.invokeLater(() -> Messages.showInfoMessage((Project)aClass.getProject(), (String)InspectionGadgetsBundle.message("utility.class.without.private.constructor.cant.generate.constructor.message", new Object[0]), (String)InspectionGadgetsBundle.message("utility.class.without.private.constructor.cant.generate.constructor.title", new Object[0])));
            }
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
            PsiElementFactory factory = psiFacade.getElementFactory();
            PsiMethod constructor = factory.createConstructor();
            PsiModifierList modifierList = constructor.getModifierList();
            modifierList.setModifierProperty("private", true);
            aClass.add((PsiElement)constructor);
            CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)project);
            styleManager.reformat((PsiElement)constructor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/UtilityClassWithoutPrivateConstructorInspection$CreateEmptyPrivateConstructor", "getFamilyName"));
        }
    }
}

