/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.psi.PsiClass;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.MakeClassFinalFix;
import com.siyeh.ig.psiutils.UtilityClassUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NonFinalUtilityClassInspection
extends BaseInspection {
    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new MakeClassFinalFix((PsiClass)infos[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("non.final.utility.class.problem.descriptor", new Object[0]);
        if (string == null) {
            NonFinalUtilityClassInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NonFinalUtilityClassVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/NonFinalUtilityClassInspection", "buildErrorString"));
    }

    private static class NonFinalUtilityClassVisitor
    extends BaseInspectionVisitor {
        private NonFinalUtilityClassVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                NonFinalUtilityClassVisitor.$$$reportNull$$$0(0);
            }
            if (!UtilityClassUtil.isUtilityClass(aClass)) {
                return;
            }
            if (aClass.hasModifierProperty("final") || aClass.hasModifierProperty("abstract")) {
                return;
            }
            this.registerClassError(aClass, aClass);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/classlayout/NonFinalUtilityClassInspection$NonFinalUtilityClassVisitor", "visitClass"));
        }
    }
}

