/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.PsiFieldImpl;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.EqualityToEqualsFix;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class NumberEqualityInspection
extends BaseInspection {
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("number.comparison.problem.descriptor", new Object[0]);
        if (string == null) {
            NumberEqualityInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NumberEqualityVisitor();
    }

    @Override
    protected InspectionGadgetsFix @NotNull [] buildFixes(Object ... infos) {
        InspectionGadgetsFix[] inspectionGadgetsFixArray = EqualityToEqualsFix.buildEqualityFixes((PsiBinaryExpression)infos[0]);
        if (inspectionGadgetsFixArray == null) {
            NumberEqualityInspection.$$$reportNull$$$0(1);
        }
        return inspectionGadgetsFixArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/NumberEqualityInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class NumberEqualityVisitor
    extends BaseInspectionVisitor {
        private NumberEqualityVisitor() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression2) {
            if (expression2 == null) {
                NumberEqualityVisitor.$$$reportNull$$$0(0);
            }
            super.visitBinaryExpression(expression2);
            if (!ComparisonUtils.isEqualityComparison((PsiExpression)expression2)) {
                return;
            }
            PsiExpression rhs = expression2.getROperand();
            if (!NumberEqualityVisitor.hasNumberType(rhs)) {
                return;
            }
            PsiExpression lhs = expression2.getLOperand();
            if (!NumberEqualityVisitor.hasNumberType(lhs)) {
                return;
            }
            if (NumberEqualityVisitor.isUniqueConstant(rhs) || NumberEqualityVisitor.isUniqueConstant(lhs)) {
                return;
            }
            this.registerError((PsiElement)expression2.getOperationSign(), expression2);
        }

        private static boolean isUniqueConstant(PsiExpression expression2) {
            PsiReferenceExpression ref = (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2), PsiReferenceExpression.class);
            if (ref == null) {
                return false;
            }
            PsiField target = (PsiField)ObjectUtils.tryCast((Object)ref.resolve(), PsiField.class);
            if (target == null) {
                return false;
            }
            if (target instanceof PsiEnumConstant) {
                return true;
            }
            if (!(target instanceof PsiFieldImpl)) {
                return false;
            }
            if (!target.hasModifierProperty("static") || !target.hasModifierProperty("final")) {
                return false;
            }
            PsiExpression initializer = PsiFieldImpl.getDetachedInitializer((PsiVariable)target);
            return ExpressionUtils.isNewObject(initializer);
        }

        private static boolean hasNumberType(PsiExpression expression2) {
            return TypeUtils.expressionHasTypeOrSubtype(expression2, "java.lang.Number");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/bugs/NumberEqualityInspection$NumberEqualityVisitor", "visitBinaryExpression"));
        }
    }
}

