/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.BoolUtils;
import org.jetbrains.annotations.NotNull;

public class ConstantAssertConditionInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("constant.assert.condition.problem.descriptor", new Object[0]);
        if (string == null) {
            ConstantAssertConditionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConstantAssertConditionVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/ConstantAssertConditionInspection", "buildErrorString"));
    }

    private static class ConstantAssertConditionVisitor
    extends BaseInspectionVisitor {
        private ConstantAssertConditionVisitor() {
        }

        public void visitAssertStatement(PsiAssertStatement statement) {
            super.visitAssertStatement(statement);
            PsiExpression assertCondition = statement.getAssertCondition();
            PsiExpression expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)assertCondition);
            if (expression2 == null) {
                return;
            }
            if (BoolUtils.isFalse(expression2)) {
                return;
            }
            if (!PsiUtil.isConstantExpression((PsiExpression)expression2)) {
                return;
            }
            this.registerError((PsiElement)expression2, new Object[0]);
        }
    }
}

