/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.testIntegration.TestCreator;
import com.intellij.testIntegration.createTest.CreateTestAction;
import com.intellij.util.IncorrectOperationException;

public class JavaTestCreator
implements TestCreator {
    private static final Logger LOG = Logger.getInstance(JavaTestCreator.class);

    public boolean isAvailable(Project project, Editor editor, PsiFile file) {
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = JavaTestCreator.findElement(file, offset);
        return CreateTestAction.isAvailableForElement(element);
    }

    public void createTest(Project project, Editor editor, PsiFile file) {
        try {
            CreateTestAction action = new CreateTestAction();
            PsiElement element = JavaTestCreator.findElement(file, editor.getCaretModel().getOffset());
            if (CreateTestAction.isAvailableForElement(element)) {
                action.invoke(project, editor, element);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.warn((Throwable)e);
        }
    }

    private static PsiElement findElement(PsiFile file, int offset) {
        PsiElement element = file.findElementAt(offset);
        if (element == null && offset == file.getTextLength()) {
            element = file.findElementAt(offset - 1);
        }
        return element;
    }
}

